% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_npp.R
\name{lm.npp}
\alias{lm.npp}
\title{Posterior of normalized power prior (NPP) for normal linear models}
\usage{
lm.npp(
  formula,
  data.list,
  offset.list = NULL,
  beta.mean = NULL,
  beta.sd = NULL,
  sigmasq.shape = 2.1,
  sigmasq.scale = 1.1,
  a0.shape1 = 1,
  a0.shape2 = 1,
  a0.lower = NULL,
  a0.upper = NULL,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates.}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical data sets.}

\item{offset.list}{a list of vectors giving the offsets for each data. The length of offset.list is equal to
the length of data.list. The length of each element of offset.list is equal to the number
of rows in the corresponding element of data.list. Defaults to a list of vectors of 0s.}

\item{beta.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the mean parameters for the initial prior on regression coefficients. If a scalar is provided,
beta.mean will be a vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{beta.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients.
Conditional on the variance parameter sigmasq for the outcome, beta.sd * sqrt(sigmasq) gives
the sd for the initial prior on regression coefficients. If a scalar is provided, same as for
beta.mean. Defaults to a vector of 10s.}

\item{sigmasq.shape}{shape parameter for inverse-gamma prior on variance parameter. Defaults to 2.1.}

\item{sigmasq.scale}{scale parameter for inverse-gamma prior on variance parameter. Defaults to 1.1.}

\item{a0.shape1}{first shape parameter for the i.i.d. beta prior on a0 vector. When \code{a0.shape1 == 1} and
\code{a0.shape2 == 1}, a uniform prior is used.}

\item{a0.shape2}{second shape parameter for the i.i.d. beta prior on a0 vector. When \code{a0.shape1 == 1} and
\code{a0.shape2 == 1}, a uniform prior is used.}

\item{a0.lower}{a scalar or a vector whose dimension is equal to the number of historical data sets giving the
lower bounds for each element of the a0 vector. If a scalar is provided, a0.lower will be a
vector of repeated elements of the given scalar. Defaults to a vector of 0s.}

\item{a0.upper}{a scalar or a vector whose dimension is equal to the number of historical data sets giving the
upper bounds for each element of the a0 vector. If a scalar is provided, same as for a0.lower.
Defaults to a vector of 1s.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g. seed, refresh, init).}
}
\value{
The function returns an object of class \code{draws_df} giving posterior samples.
}
\description{
Sample from the posterior distribution of a normal linear model using the NPP by Duan et al. (2006) \url{doi:10.1002/env.752}.
The power prior parameters (\eqn{a_0}'s) are treated as random with independent beta priors. The current and historical
data sets are assumed to have a common dispersion parameter (\eqn{\sigma^2}) with an inverse-gamma prior. Conditional on
\eqn{\sigma^2}, the initial priors on the regression coefficients are independent normal distributions with variance
\eqn{\propto (\sigma^2)^{-1}}. In this case, the normalizing constant for the NPP has a closed form.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  data(actg036)
  data_list = list(currdata = actg019, histdata = actg036)
  lm.npp(
    formula = cd4 ~ treatment + age + race,
    data.list = data_list,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
\references{
Duan, Y., Ye, K., and Smith, E. P. (2005). Evaluating water quality using power priors to incorporate historical information. Environmetrics, 17(1), 95–106.
}
