// (c) The HDF Group
#ifndef H5Rpublic_H
#define H5Rpublic_H
#include "H5public.h"
#include "H5Gpublic.h"
#include "H5Ipublic.h"
#include "H5Opublic.h"
#define H5R_OBJ_REF_BUF_SIZE      sizeof(haddr_t)
#define H5R_DSET_REG_REF_BUF_SIZE (sizeof(haddr_t) + 4)
#define H5R_REF_BUF_SIZE (64)
//! <!-- [H5R_type_t_snip] -->
typedef enum {
    H5R_BADTYPE         = (-1),
    H5R_OBJECT1         = 0,
    H5R_DATASET_REGION1 = 1,
    H5R_OBJECT2         = 2,
    H5R_DATASET_REGION2 = 3,
    H5R_ATTR            = 4,
    H5R_MAXTYPE         = 5
} H5R_type_t;
//! <!-- [H5R_type_t_snip] -->
//! <!-- [hobj_ref_t_snip] -->
typedef haddr_t hobj_ref_t;
//! <!-- [hobj_ref_t_snip] -->
//! <!-- [hdset_reg_ref_t_snip] -->
typedef struct {
    uint8_t __data[H5R_DSET_REG_REF_BUF_SIZE];
} hdset_reg_ref_t;
//! <!-- [hdset_reg_ref_t_snip] -->
//! <!-- [H5R_ref_t_snip] -->
typedef struct {
    union {
        uint8_t __data[H5R_REF_BUF_SIZE];
        int64_t align;
    } u;
} H5R_ref_t;
//! <!-- [H5R_ref_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL herr_t H5Rcreate_object(hid_t loc_id, const char *name, hid_t oapl_id, H5R_ref_t *ref_ptr);
H5_DLL herr_t H5Rcreate_region(hid_t loc_id, const char *name, hid_t space_id, hid_t oapl_id,
                               H5R_ref_t *ref_ptr);
H5_DLL herr_t H5Rcreate_attr(hid_t loc_id, const char *name, const char *attr_name, hid_t oapl_id,
                             H5R_ref_t *ref_ptr);
H5_DLL herr_t H5Rdestroy(H5R_ref_t *ref_ptr);
H5_DLL H5R_type_t H5Rget_type(const H5R_ref_t *ref_ptr);
H5_DLL htri_t H5Requal(const H5R_ref_t *ref1_ptr, const H5R_ref_t *ref2_ptr);
H5_DLL herr_t H5Rcopy(const H5R_ref_t *src_ref_ptr, H5R_ref_t *dst_ref_ptr);
H5_DLL hid_t H5Ropen_object(H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Ropen_object_async(const char *app_file, const char *app_func, unsigned app_line,
                                  H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Ropen_object_async(unsigned app_line, H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id,
                                  hid_t es_id);
#endif
H5_DLL hid_t H5Ropen_region(H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Ropen_region_async(const char *app_file, const char *app_func, unsigned app_line,
                                  H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Ropen_region_async(H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t oapl_id, hid_t es_id);
#endif
H5_DLL hid_t H5Ropen_attr(H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t aapl_id);
#ifndef H5_DOXYGEN
H5_DLL hid_t H5Ropen_attr_async(const char *app_file, const char *app_func, unsigned app_line,
                                H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t aapl_id, hid_t es_id);
#else
H5_DLL hid_t H5Ropen_attr_async(H5R_ref_t *ref_ptr, hid_t rapl_id, hid_t aapl_id, hid_t es_id);
#endif
H5_DLL herr_t H5Rget_obj_type3(H5R_ref_t *ref_ptr, hid_t rapl_id, H5O_type_t *obj_type);
H5_DLL ssize_t H5Rget_file_name(const H5R_ref_t *ref_ptr, char *name, size_t size);
H5_DLL ssize_t H5Rget_obj_name(H5R_ref_t *ref_ptr, hid_t rapl_id, char *name, size_t size);
H5_DLL ssize_t H5Rget_attr_name(const H5R_ref_t *ref_ptr, char *name, size_t size);
/// \cond DEV
#ifndef H5R_MODULE
#define H5Ropen_object_async(...) H5Ropen_object_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Ropen_region_async(...) H5Ropen_region_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Ropen_attr_async(...)   H5Ropen_attr_async(__FILE__, __func__, __LINE__, __VA_ARGS__)
#define H5Ropen_object_async_wrap H5_NO_EXPAND(H5Ropen_object_async)
#define H5Ropen_region_async_wrap H5_NO_EXPAND(H5Ropen_region_async)
#define H5Ropen_attr_async_wrap   H5_NO_EXPAND(H5Ropen_attr_async)
#endif
/// \endcond
#define H5R_OBJECT         H5R_OBJECT1
#define H5R_DATASET_REGION H5R_DATASET_REGION1
#ifndef H5_NO_DEPRECATED_SYMBOLS
H5_DLL H5G_obj_t H5Rget_obj_type1(hid_t id, H5R_type_t ref_type, const void *ref);
H5_DLL hid_t H5Rdereference1(hid_t obj_id, H5R_type_t ref_type, const void *ref);
#endif
H5_DLL herr_t H5Rcreate(void *ref, hid_t loc_id, const char *name, H5R_type_t ref_type, hid_t space_id);
H5_DLL herr_t H5Rget_obj_type2(hid_t id, H5R_type_t ref_type, const void *ref, H5O_type_t *obj_type);
H5_DLL hid_t H5Rdereference2(hid_t obj_id, hid_t oapl_id, H5R_type_t ref_type, const void *ref);
H5_DLL hid_t H5Rget_region(hid_t dataset, H5R_type_t ref_type, const void *ref);
H5_DLL ssize_t H5Rget_name(hid_t loc_id, H5R_type_t ref_type, const void *ref, char *name, size_t size);
#ifdef __cplusplus
}
#endif
#endif
