% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.r
\name{c_flags}
\alias{c_flags}
\title{Get C/C++ Compiler Flags for hdf5lib}
\usage{
c_flags(api = "latest")
}
\arguments{
\item{api}{A character string specifying the HDF5 API version to use.
This adds a preprocessor directive like \code{-DH5_USE_114_API_DEFAULT} to ensure
that the compiled code uses symbols compatible with a specific version of
the HDF5 API. This is useful for maintaining compatibility with older HDF5
versions. Supported values are \code{200}, \code{114}, \code{112}, \code{110}, \code{18},and \code{16}.
Defaults to \code{"latest"}, which corresponds to the newest supported API version.}
}
\value{
A scalar character vector containing the compiler flags (e.g., the
\code{-I} path to the package's \code{inst/include} directory).
}
\description{
Provides the required C/C++ compiler flags to find the HDF5 header
files bundled with the \code{hdf5lib} package.
}
\examples{
c_flags()
c_flags(api = "114")

}
\seealso{
\code{\link[=ld_flags]{ld_flags()}}
}
