% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhcartr_export_setDataDescription.R
\name{setDataDescription}
\alias{setDataDescription}
\title{setDataDescription Save brief description of the dataset used by current model.}
\usage{
setDataDescription(new_description)
}
\arguments{
\item{new_description}{the new dataset description to be saved for the current model.}
}
\value{
nothing.
}
\description{
This function setDataDescription updates global variable pkg.env$model_data_description
with a brief description of the dataset being used to train the current model. It is
later used in command output displays and plots.
}
\examples{
# source: /man/examples/setDataDescription.R

# Basic usage of setDataDescription().

# Note: we need to have a model to modify first.

# load our data.
X <- iris[,1:4]
y <- iris[,5]

# instantiate our model.
clf = HHDecisionTree(n_folds=1,
                     n_trees=1,
                     pruning=FALSE,
                     min_node_impurity=0.0)

# describe what dataset our model is using.
setDataDescription("IRIS Dataset")

# train our model.
vv <- clf$fit(X, y)
}
