% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_hc.R
\name{export_hc}
\alias{export_hc}
\title{Function to export js file the configuration options}
\usage{
export_hc(hc, filename = NULL, as = "is", name = NULL)
}
\arguments{
\item{hc}{A \code{Highcharts object}.}

\item{filename}{String of the exported file.}

\item{as}{String to define how to save the configuration options.
One of 'is', 'container', 'variable'.}

\item{name}{A variable used to put as name of the generated object if
\code{as} is \code{'variable'} and the css/js selector if is \code{as} is
container.}
}
\description{
Function to export js file the configuration options
}
\examples{

fn <- "function(){
  console.log('Category: ' + this.category);
  alert('Category: ' + this.category);
}"

hc <- highcharts_demo() \%>\% 
  hc_plotOptions(
    series = list(
      cursor = "pointer",
        point = list(
          events = list(
            click = JS(fn)
         )
       )
   )
 )

\dontrun{
export_hc(hc, filename = "~/hc_is.js", as = "is")
export_hc(hc, filename = "~/hc_vr.js", as = "variable", name = "objectname")
export_hc(hc, filename = "~/hc_ct.js", as = "container", name = "#selectorid")
}

}
