% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HEAVYmodel.R
\name{HEAVYmodel}
\alias{HEAVYmodel}
\title{HEAVY model estimation}
\usage{
HEAVYmodel(data, startingValues = NULL)
}
\arguments{
\item{data}{an \code{xts} object where the first column is a vector of returns 
and the second column is a vector of realized stock market variation}

\item{startingValues}{a vector of alternative starting values: first three arguments for variance equation and last three arguments for measurement equation.}
}
\value{
The function outputs an object of class \code{HEAVYmodel}, a list containing
\itemize{
  \item coefficients = estimated coefficients.
  \item se = robust standard errors based on inverted Hessian matrix.
  \item residuals = the residuals in the return equation.
  \item llh = the two-component log-likelihood values.
  \item varCondVariances = conditional variances in the variance equation.
  \item RMCondVariances = conditional variances in the RM equation.
  \item data = the input data.
}
The class HEAVYmodel has the following methods: plot.HEAVYmodel, predict.HEAVYmodel, 
print.HEAVYmodel, and summary.HEAVYmodel.
}
\description{
This function calculates the High frEquency bAsed VolatilitY (HEAVY) model proposed in Shephard and Sheppard (2010).
}
\details{
Let \eqn{r_{t}} and \eqn{RM_{t}} be series of demeaned returns and realized measures of
daily stock price variation. The HEAVY model is a two-component model.
We assume \eqn{r_{t} = h_{t}^{1/2} Z_{t}} where \eqn{Z_t} is an i.i.d. zero-mean 
and unit-variance innovation term. The dynamics of the HEAVY model are given by

\deqn{
   h_{t} = \omega + \alpha RM_{t-1} + \beta h_{t-1}
 }
 and 
 \deqn{
   \mu_{t} = \omega_{R} + \alpha_{R} RM_{t-1} + \beta_{R} \mu_{t-1}.
 }
 
The two equations are estimated separately as mentioned in Shephard and Sheppard (2010).
We report robust standard errors based on the matrix-product of inverted Hessians and
the outer product of gradients.

Note that we always demean the returns in the data input as we don't include a constant in the mean equation.
}
\examples{
\dontshow{if (!grepl("debian", sessionInfo()["platform"], fixed = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# Calculate returns in percentages
logReturns <- 100 * makeReturns(SPYRM$CLOSE)[-1]

# Combine both returns and realized measures into one xts
# Due to return calculation, the first observation is missing
dataSPY <- xts::xts(cbind(logReturns, SPYRM$BPV5[-1] * 10000), order.by = SPYRM$DT[-1])

# Fit the HEAVY model
fittedHEAVY <- HEAVYmodel(dataSPY)

# Examine the estimated coefficients and robust standard errors
fittedHEAVY

# Calculate iterative multi-step-ahead forecasts
predict(fittedHEAVY, stepsAhead = 12)
\dontshow{\}) # examplesIf}
}
\references{
Shephard, N. and Sheppard, K. (2010). Realising the future: Forecasting with high frequency based volatility (HEAVY) models. Journal of Applied Econometrics 25, 197--231.
}
\seealso{
\code{\link{predict.HEAVYmodel}}
}
\author{
Onno Kleen and Emil Sjorup.
}
