% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasures.R
\name{ReMeDI}
\alias{ReMeDI}
\title{ReMeDI}
\usage{
ReMeDI(pData, kn = 1, lags = 1, makeCorrelation = FALSE)
}
\arguments{
\item{pData}{\code{xts} or \code{data.table} containing the log-prices of the asset}

\item{kn}{numeric of length 1 determining the tuning parameter kn this controls the lengths of the non-overlapping interval in the ReMeDI estimation}

\item{lags}{numeric containing integer values indicating the lags for which to estimate the (co)variance}

\item{makeCorrelation}{logical indicating whether to transform the autocovariances into autocorrelations. 
The estimate of variance is imprecise and thus, constructing the correlation like this may show correlations that fall outside \eqn{(-1,1)}.}
}
\description{
This function estimates the auto-covariance of market-microstructure noise

Let the observed price \eqn{Y_{t}} be given as \eqn{Y_{t} = X_{t} + \varepsilon_{t}}, where \eqn{X_{t}} is the efficient price and \eqn{\varepsilon_t} is the market microstructure noise

The estimator of the \eqn{l}'th lag of the market microstructure is defined as:
\deqn{
    \hat{R}^{n}_{t,l} = \frac{1}{n_{t}} \sum_{i=2k_{n}}^{n_{t}-k_{n}-l} \left(Y_{i+l}^n - Y_{i+l+k_{n}}^{n} \right) \left(Y_{i}^n - Y_{i- 2k_{n}}^{n} \right),
}
where \eqn{k_{n}} is a tuning parameter. In the function \code{\link{knChooseReMeDI}}, we provide a function to estimate the optimal \eqn{k_{n}} parameter.
}
\note{
We Thank Merrick Li for contributing his Matlab code for this estimator.
}
\examples{
\dontshow{if (!grepl("debian", sessionInfo()["platform"], fixed = TRUE)) withAutoprint(\{ # examplesIf}
\dontshow{data.table::setDTthreads(2)}
remed <- ReMeDI(sampleTData[as.Date(DT) == "2018-01-02", ], kn = 2, lags = 1:8)
# We can also use the algorithm for choosing the kn tuning parameter
optimalKn <- knChooseReMeDI(sampleTData[as.Date(DT) == "2018-01-02",],
                            knMax = 10, tol = 0.05, size = 3,
                            lower = 2, upper = 5, plot = TRUE)
optimalKn
remed <- ReMeDI(sampleTData[as.Date(DT) == "2018-01-02", ], kn = optimalKn, lags = 1:8)
\dontshow{\}) # examplesIf}
}
\references{
Li, M. and Linton, O. (2021). A ReMeDI for microstructure noise. Econometrica, forthcoming
}
\author{
Emil Sjoerup.
}
\keyword{autocorrelation}
\keyword{autocovariance}
\keyword{microstructure}
\keyword{noise}
