% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WaterLevelDataFrame-methods.R
\name{getGaugingStations}
\alias{getGaugingStations}
\alias{getGaugingStations,WaterLevelDataFrame-method}
\alias{getGaugingStations-method}
\title{Extract a WaterLevelDataFrame's slot gauging_stations}
\usage{
getGaugingStations(x)

\S4method{getGaugingStations}{WaterLevelDataFrame}(x)
}
\arguments{
\item{x}{an object of class \linkS4class{WaterLevelDataFrame}.}
}
\value{
The function above extracts the slot \code{gauging_stations} and
  returns an object of class \code{\link[base]{data.frame}}, which might
  contain gauging station data that have been used for the interpolation of a
  water level for the specified date.
}
\description{
A function to extract the slot \code{gauging_stations} from an 
  object of class \linkS4class{WaterLevelDataFrame}.
}
\examples{
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf)
getGaugingStations(wldf)

}
\seealso{
\code{\link[=setGaugingStations<-]{setGaugingStations<--method}}
}
