% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-WaterLevelDataFrame.R
\docType{class}
\name{WaterLevelDataFrame-class}
\alias{WaterLevelDataFrame-class}
\title{S4 class for 1d water level data}
\description{
The S4 class \linkS4class{WaterLevelDataFrame} is inherited from
  the S3 class \code{\link[base]{data.frame}} and stores 1d water level
  information together with the official stationing along the German federal
  waterways Elbe and Rhine.
}
\details{
In addition to the 1d water level data stored in the 
  \code{\link[base]{data.frame}} further slots contain necessary information
  used for or computed during the computation of water levels:
}
\section{Slots}{

\describe{
\item{\code{.Data}}{contains the \code{\link[base]{data.frame}} with at least three
columns: \code{station}, \code{station_int} and \code{w}. The columns
\code{station} and \code{station_int} represent the official stationing
along the waterways in two different formats. They are totally exchangeable
since \code{station <- \link[base:numeric]{as.numeric}(station_int / 1000)}
and \code{station_int <- \link[base:integer]{as.integer}(station * 1000)}.
The column \code{w} represents the height of the water level relative to
standard elevation zero (DHHN92). These first three columns are required, but
further columns can be added.}

\item{\code{river}}{is a required slot clearly determining the location of a station.
Possible values of \code{river} have to be type \code{character}, have to
have a length of one and are either \strong{Elbe} or \strong{Rhine}.}

\item{\code{time}}{is a slot determining the time for which the water level has been
computed. \code{time} has to be type \code{\link[base:POSIXct]{c("POSIXct",
"POSIXt")}}, has to have a length of one and be in the range between
\code{1960-01-01 00:00:00 CET} and now (\code{Sys.time()}) or \code{NA}.}

\item{\code{gauging_stations}}{possibly contains a \code{\link[base]{data.frame}}
with relevant information about gauging stations within the relevant
\code{river} stretch and the closer surrounding up- and downstream of the
relevant \code{river} stretch. It is usually filled by the functions 
\code{\link{waterLevel}} or \code{\link{waterLevelPegelonline}}.}

\item{\code{gauging_stations_missing}}{possibly contains a vector of type
\code{character} with names of gauging stations for which no gauging data
existed for the requested \code{time}. It is automatically filled by the
functions \code{\link{waterLevel}}, \code{\link{waterLevelPegelonline}},
\code{\link{waterLevelFlys3}} and \code{\link{waterLevelFlys3Seq}}.}

\item{\code{comment}}{contains information on which function has been used to create
(\code{\link{WaterLevelDataFrame}}) or compute (\code{\link{waterLevel}},
\code{\link{waterLevelPegelonline}}, \code{\link{waterLevelFlys3}} and
\code{\link{waterLevelFlys3Seq}}) an object of class
 \linkS4class{WaterLevelDataFrame}.}
}}

