% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{default_locales}
\alias{default_locales}
\title{A table containing a mapping of default locale names to base locales}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 226 rows and 2 columns.
}
\usage{
default_locales
}
\description{
This is a table that contains base locale names (e.g., \code{"en"}, \code{"de"})
alongside their default locale names. This indicates that \code{"en"} maps to
\code{"en-US"} and \code{"de"} should map to \code{"de-DE"}. Throughout the \strong{i18n}
datasets, base names are used instead of their expanded equivalents.

There are 226 rows and the following 2 columns:
\itemize{
\item \code{default_locale} (\code{character})
\item \code{base_locale} (\code{character})
}

The \code{default_locale} column contains the expanded locale names (e.g.,
\code{"en-US"}) that do not normally appear within the \emph{CLDR} datasets but are
valid aliases for the base locale names (e.g., \code{"en"}) found in the
\code{base_locale} column.
}
\keyword{datasets}
