% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processing.R
\name{filter_barcodes}
\alias{filter_barcodes}
\title{Filter clonotypes using barcodes from single-cell metadata}
\usage{
filter_barcodes(.data, .barcodes)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.barcodes}{Character vector. Vector of barcodes to use for
filtering.}
}
\value{
An immune repertoire or a list of immune repertoires with clonotypes which have
one or more barcodes in the input barcode vector and with clonotype abundances corrected.
}
\description{
Given the input data and a vector of barcodes,
the function returns the input with cells which has
at least one of the given barcode. Columns with clonotype counts
and proportions are changed accordingly to the filtered barcodes.
}
\examples{
data(immdata)
# Create a fake single-cell data
df <- immdata$data[[1]]
df$Barcode <- "AAAAACCCCC"
df$Barcode[51:nrow(df)] <- "GGGGGCCCCC"
barcodes <- "AAAAACCCCC"
df <- filter_barcodes(df, barcodes)
nrow(df)
}
\concept{single_cell}
