% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{NodeLocalCorrelation.intensitynet}
\alias{NodeLocalCorrelation.intensitynet}
\title{Gives the node local Moran-I, Getis-Gstar or Geary-c correlations}
\source{
*Luc Anselin. A Local Indicator of Multivariate SpatialAssociation: Extending Geary's c, Geographical Analysis 2018; doi: https://doi.org/10.1111/gean.12164
}
\usage{
\method{NodeLocalCorrelation}{intensitynet}(obj, dep_type = "moran", intensity)
}
\arguments{
\item{obj}{intensitynet object}

\item{dep_type}{'moran', 'getis' or 'geary'. Type of local correlation to be computed (Moran-i, Getis-Gstar, Geary-c),
default = 'moran'.}

\item{intensity}{vector containing the values to calculate the specified correlation for each node in the network.}
}
\value{
a vector containing two values. The first value is a vector with the specified local correlations for each node. 
The second values is the  given intensitynet class object but with the correlations added to the node attributes of its network.
}
\description{
Gives the node local Moran-I, Getis-Gstar or Geary-c correlations
}
\examples{
\dontrun{
data("und_intnet_chicago")
g <- und_intnet_chicago$graph
data_moran <- NodeLocalCorrelation(und_intnet_chicago, 
                                   dep_type = 'moran', 
                                   intensity = igraph::vertex_attr(g)$intensity)
moran_i <- data_moran$correlation
intnet <- data_moran$intnet
}
}
