% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jl_.R
\name{jl-helpers}
\alias{jl-helpers}
\alias{is_jl}
\alias{jl_put}
\alias{jl_get}
\alias{jl}
\alias{jl_formula}
\alias{jl_contrasts}
\alias{jl_data}
\alias{jl_family}
\title{Helpers for converting model specifications in R to Julia equivalents}
\usage{
is_jl(x, type)

jl_put(x)

jl_get(x)

jl(expr, ..., .R = FALSE, .passthrough = FALSE)

jl_formula(formula)

jl_contrasts(df, cols = NULL, show_code = FALSE)

jl_data(df)

jl_family(family = c("gaussian", "binomial", "poisson"))
}
\arguments{
\item{x}{An object}

\item{type}{Type of Julia object to additional test for}

\item{expr}{A string of Julia code}

\item{...}{Elements interpolated into \code{expr}.
\itemize{
\item If all named, elements are introduced as Julia variables in the \code{expr}
\item If all unnamed, elements are interpolated into \code{expr} via \code{\link[=sprintf]{sprintf()}}
}}

\item{.R}{Whether to simplify and return as R object, if possible.}

\item{.passthrough}{Whether to return \code{expr} as-is if it's already a Julia
object. Mostly for internal use.}

\item{formula}{A string or formula object}

\item{df}{A data frame}

\item{cols}{A subset of columns to make contrast specifiations for}

\item{show_code}{Whether to print corresponding Julia code as a side-effect}

\item{family}{The distributional family as string or \verb{<family>} object}
}
\value{
A Julia object of type \verb{<JuliaProxy>}
}
\description{
Helpers for converting model specifications in R to Julia equivalents
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
jlme_setup(restart = TRUE)

# (general) Use `jl()` to evaluate arbitrary Julia expressions from string
jl("1 .+ [1,3]")

# `jl()` takes elements in `...` that you can reference in the expression
jl("1 .+ a", a = c(1L, 3L)) # Named arguments are introduced as variables
jl("1 .+ \%s", "[1,2]") # Unnamed arguments are interpolated via `sprintf()`

# Use `is_jl()` to test if object is a Julia (`<JuliaProxy>`) object
is_jl(jl("1"))

# Use `jl_put()` and `jl_get()` to transfer data between R and Julia
jl_put(1L)
identical(jl_get(jl_put(1L)), 1L)


# (modelling) set up model data in R
x <- mtcars
x$cyl_helm <- factor(x$cyl)
contrasts(x$cyl_helm) <- contr.helmert(3)
colnames(contrasts(x$cyl_helm)) <- c("4vs6", "4&6vs8")

# Formula conversion with
julia_formula <- jl_formula(mpg ~ am * cyl_helm)
julia_formula

# Data frame conversion
julia_data <- jl_data(x)
julia_data

# Contrasts construction (`show_code = TRUE` pretty prints the Julia code)
julia_contrasts <- jl_contrasts(x, show_code = TRUE)
julia_contrasts

# Family conversion
julia_family <- jl_family("binomial")
julia_family

stop_julia()
}
\dontshow{\}) # examplesIf}
}
\keyword{internal}
