% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label.R
\name{LabeljsMetric}
\alias{LabeljsMetric}
\title{LabeljsMetric: Apply label information to jstable metric object using label data}
\usage{
LabeljsMetric(obj.metric, ref)
}
\arguments{
\item{obj.metric}{metric of lmer.display, coxme.display}

\item{ref}{Label data made by mk.lev function}
}
\value{
metric of lmer.display, coxme.display with label information
}
\description{
Apply label information to metric object of jstable using label data
}
\details{
DETAILS
}
\examples{
 library(coxme)
 fit <- coxme(Surv(time, status) ~ sex + ph.ecog + ph.karno + (1|inst) +(1|sex), lung)
 fit.table <- coxme.display(fit)
 lung.label <- mk.lev(lung)
 LabeljsTable(fit.table$table, ref = lung.label)
 LabeljsRanef(fit.table$ranef, ref = lung.label)
 LabeljsMetric(fit.table$metric, ref = lung.label)
}
