% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-rnn.R
\name{layer_bidirectional}
\alias{layer_bidirectional}
\title{Bidirectional wrapper for RNNs.}
\usage{
layer_bidirectional(
  object,
  layer,
  merge_mode = "concat",
  weights = NULL,
  backward_layer = NULL,
  ...
)
}
\arguments{
\item{object}{Object to compose the layer with. A tensor, array, or sequential model.}

\item{layer}{\code{RNN} instance, such as
\code{\link[=layer_lstm]{layer_lstm()}} or \code{\link[=layer_gru]{layer_gru()}}.
It could also be a \code{\link[=Layer]{Layer()}} instance
that meets the following criteria:
\enumerate{
\item Be a sequence-processing layer (accepts 3D+ inputs).
\item Have a \code{go_backwards}, \code{return_sequences} and \code{return_state}
attribute (with the same semantics as for the \code{RNN} class).
\item Have an \code{input_spec} attribute.
\item Implement serialization via \code{get_config()} and \code{from_config()}.
Note that the recommended way to create new RNN layers is to write a
custom RNN cell and use it with \code{\link[=layer_rnn]{layer_rnn()}}, instead of
subclassing with \code{\link[=Layer]{Layer()}} directly.
When \code{return_sequences} is \code{TRUE}, the output of the masked
timestep will be zero regardless of the layer's original
\code{zero_output_for_mask} value.
}}

\item{merge_mode}{Mode by which outputs of the forward and backward RNNs
will be combined. One of \verb{\{"sum", "mul", "concat", "ave", NULL\}}.
If \code{NULL}, the outputs will not be combined,
they will be returned as a list. Defaults to \code{"concat"}.}

\item{weights}{see description}

\item{backward_layer}{Optional \code{RNN},
or \code{Layer()} instance to be used to handle
backwards input processing.
If \code{backward_layer} is not provided, the layer instance passed
as the \code{layer} argument will be used to generate the backward layer
automatically.
Note that the provided \code{backward_layer} layer should have properties
matching those of the \code{layer} argument, in particular
it should have the same values for \code{stateful}, \code{return_states},
\code{return_sequences}, etc. In addition, \code{backward_layer}
and \code{layer} should have different \code{go_backwards} argument values.
A \code{ValueError} will be raised if these requirements are not met.}

\item{...}{For forward/backward compatability.}
}
\value{
The return value depends on the value provided for the first argument.
If  \code{object} is:
\itemize{
\item a \code{keras_model_sequential()}, then the layer is added to the sequential model
(which is modified in place). To enable piping, the sequential model is also
returned, invisibly.
\item a \code{keras_input()}, then the output tensor from calling \code{layer(input)} is returned.
\item \code{NULL} or missing, then a \code{Layer} instance is returned.
}
}
\description{
Bidirectional wrapper for RNNs.
}
\section{Call Arguments}{
The call arguments for this layer are the same as those of the
wrapped RNN layer. Beware that when passing the \code{initial_state}
argument during the call of this layer, the first half in the
list of elements in the \code{initial_state} list will be passed to
the forward RNN call and the last half in the list of elements
will be passed to the backward RNN call.
}

\section{Note}{
instantiating a \code{Bidirectional} layer from an existing RNN layer
instance will not reuse the weights state of the RNN layer instance -- the
\code{Bidirectional} layer will have freshly initialized weights.
}

\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = c(5, 10)) \%>\%
  layer_bidirectional(layer_lstm(units = 10, return_sequences = TRUE)) \%>\%
  layer_bidirectional(layer_lstm(units = 10)) \%>\%
  layer_dense(5, activation = "softmax")

model \%>\% compile(loss = "categorical_crossentropy",
                  optimizer = "rmsprop")

# With custom backward layer
forward_layer <- layer_lstm(units = 10, return_sequences = TRUE)
backward_layer <- layer_lstm(units = 10, activation = "relu",
                             return_sequences = TRUE, go_backwards = TRUE)

model <- keras_model_sequential(input_shape = c(5, 10)) \%>\%
  bidirectional(forward_layer, backward_layer = backward_layer) \%>\%
  layer_dense(5, activation = "softmax")

model \%>\% compile(loss = "categorical_crossentropy",
                  optimizer = "rmsprop")
}\if{html}{\out{</div>}}
}

\section{States}{
A \code{Bidirectional} layer instance has property \code{states}, which you can access
with \code{layer$states}. You can also reset states using \code{\link[=reset_state]{reset_state()}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/recurrent_layers/bidirectional#bidirectional-class}
}

Other rnn layers: \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_aug_mix}()} \cr
\code{\link{layer_auto_contrast}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_cut_mix}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_equalization}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_flax_module_wrapper}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_jax_model_wrapper}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_num_bounding_boxes}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_mel_spectrogram}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_mix_up}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_rand_augment}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_color_degeneration}()} \cr
\code{\link{layer_random_color_jitter}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_erasing}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_gaussian_blur}()} \cr
\code{\link{layer_random_grayscale}()} \cr
\code{\link{layer_random_hue}()} \cr
\code{\link{layer_random_invert}()} \cr
\code{\link{layer_random_perspective}()} \cr
\code{\link{layer_random_posterization}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_saturation}()} \cr
\code{\link{layer_random_sharpness}()} \cr
\code{\link{layer_random_shear}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rms_normalization}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_solarization}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_stft_spectrogram}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cell_simple}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{layers}
\concept{rnn layers}
