% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lavaanPlot.R
\name{nice_lavaanPlot}
\alias{nice_lavaanPlot}
\title{Make a quick \code{lavaanPlot}}
\usage{
nice_lavaanPlot(
  model,
  node_options = list(shape = "box", fontname = "Helvetica"),
  edge_options = list(color = "grey"),
  coefs = TRUE,
  stand = TRUE,
  covs = FALSE,
  stars = list("regress"),
  sig = 0.05,
  graph_options = list(rankdir = "LR"),
  ...
)
}
\arguments{
\item{model}{SEM or CFA model to plot.}

\item{node_options}{Shape and font name.}

\item{edge_options}{Colour of edges.}

\item{coefs}{Logical, whether to plot coefficients.}

\item{stand}{Logical, whether to standardized coefficients.}

\item{covs}{Logical, whether to plot covariances}

\item{stars}{Logical, whether to plot significance stars.}

\item{sig}{Significance threshold.}

\item{graph_options}{Read from left to right, rather than from top to bottom.}

\item{...}{Arguments to be passed to function \code{lavaanPlot::lavaanPlot}.}
}
\value{
A lavaanPlot, of classes \code{c("grViz", "htmlwidget")}, representing the
specified \code{lavaan} model.
}
\description{
Make a quick and decent-looking \code{lavaanPlot}.
}
\section{Illustrations}{


\if{html}{\figure{lavaanPlot.png}{options: width="400"}}
}

\examples{
(latent <- list(visual = paste0("x", 1:3),
                textual = paste0("x", 4:6),
                speed = paste0("x", 7:9)))

HS.model <- write_lavaan(latent = latent)
cat(HS.model)

library(lavaan)
fit <- cfa(HS.model, HolzingerSwineford1939)
nice_lavaanPlot(fit)
}
\keyword{CFA}
\keyword{fit}
\keyword{lavaan}
\keyword{plot}
