% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_tidySEM.R
\name{nice_tidySEM}
\alias{nice_tidySEM}
\title{Make a quick \code{tidySEM} plot}
\usage{
nice_tidySEM(
  fit,
  layout = NULL,
  hide_nonsig_edges = FALSE,
  hide_var = TRUE,
  hide_mean = TRUE,
  est_std = TRUE,
  label,
  label_location = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{fit}{SEM or CFA model fit to plot.}

\item{layout}{A matrix (or data.frame) that describes the structure; see
\code{\link[tidySEM]{get_layout}}. If a named list is provided,
with names "IV" (independent variables), "M" (mediator), and
"DV" (dependent variables), \code{nice_tidySEM} attempts to write
the layout matrix automatically.}

\item{hide_nonsig_edges}{Logical, hides non-significant edges.
Defaults to FALSE.}

\item{hide_var}{Logical, hides variances. Defaults to TRUE.}

\item{hide_mean}{Logical, hides means/node labels. Defaults to TRUE.}

\item{est_std}{Logical, whether to use the standardized coefficients.
Defaults to TRUE.}

\item{label}{Labels to be used on the plot. As elsewhere in
\code{lavaanExtra}, it is provided as a named list with
format \code{(colname = "label")}.}

\item{label_location}{Location of label along the path, as a percentage
(defaults to middle, 0.5).}

\item{plot}{Logical, whether to plot the result (default). If \code{FALSE},
returns the \code{tidy_sem} object, which can be further edited
as needed.}

\item{...}{Arguments to be passed to \code{\link[tidySEM]{prepare_graph}}.}
}
\value{
A tidySEM plot, of class ggplot, representing the specified
\code{lavaan} model.
}
\description{
Make a quick and decent-looking \code{tidySEM} plot.
}
\section{Illustrations}{


\if{html}{\figure{nice_tidySEM.png}{options: width="400"}}
}

\examples{

# Calculate scale averages
library(lavaan)
data <- HolzingerSwineford1939
data$visual <- rowMeans(data[paste0("x", 1:3)])
data$textual <- rowMeans(data[paste0("x", 4:6)])
data$speed <- rowMeans(data[paste0("x", 7:9)])

# Define our variables
IV <- c("sex", "ageyr", "agemo", "school")
M <- c("visual", "grade")
DV <- c("speed", "textual")

# Define our lavaan lists
mediation <- list(speed = M, textual = M, visual = IV, grade = IV)

# Define indirect object
structure <- list(IV = IV, M = M, DV = DV)

# Write the model, and check it
model <- write_lavaan(mediation, indirect = structure, label = TRUE)
cat(model)

# Fit model
fit <- sem(model, data)

# Plot model
\donttest{
nice_tidySEM(fit, layout = structure)
}
}
\keyword{CFA}
\keyword{fit}
\keyword{lavaan}
\keyword{plot}
\keyword{table_results}
\keyword{tidySEM}
