% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.R
\name{lev_weighted_token_sort_ratio}
\alias{lev_weighted_token_sort_ratio}
\title{Weighted version of lev_token_sort_ratio()}
\usage{
lev_weighted_token_sort_ratio(a, b, weights = list(), ...)
}
\arguments{
\item{a, b}{The input strings}

\item{weights}{List of token weights. For example, \code{weights = list(foo = 0.9, bar = 0.1)}. Any
tokens omitted from \code{weights} will be given a weight of 1.}

\item{...}{Additional arguments to be passed to \code{\link[stringdist:stringdist]{stringdist::stringdistmatrix()}} or
\code{\link[stringdist:stringsim]{stringdist::stringsimmatrix()}}.}
}
\value{
Float
}
\description{
This function tokenises inputs, sorts tokens and computes similarities for each pair of tokens.
Similarity scores are weighted based on the \code{weights} argument, and a total similarity score is
returned in the same manner as \code{\link[=lev_weighted_token_ratio]{lev_weighted_token_ratio()}}.
}
\seealso{
\code{\link[=lev_token_sort_ratio]{lev_token_sort_ratio()}}

Other weighted token functions: 
\code{\link{lev_weighted_token_ratio}()},
\code{\link{lev_weighted_token_set_ratio}()}
}
\concept{weighted token functions}
