% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-simulate.R
\name{sim.create_x}
\alias{sim.create_x}
\title{Create an input data frame X for simulated data}
\usage{
sim.create_x(
  N,
  covariates,
  names,
  n_categs,
  t_data,
  t_jitter,
  t_effect_range,
  continuous_info
)
}
\arguments{
\item{N}{Number of individuals.}

\item{covariates}{Integer vector that defines the types of covariates
(other than id and age). If not given, only the id and age
covariates are created. Different integers correspond to the following
covariate types:
\itemize{
  \item 0 = disease-related age
  \item 1 = other continuous covariate
  \item 2 = a categorical covariate that interacts with age
  \item 3 = a categorical covariate that acts as a group offset
  \item 4 = a categorical covariate that that acts as a group offset AND
  is restricted to have value 0 for controls and 1 for cases
}}

\item{names}{Covariate names.}

\item{n_categs}{An integer vector defining the number of categories
for each categorical covariate, so that \code{length(n_categs)} equals to
the number of 2's and 3's in the \code{covariates} vector.}

\item{t_data}{Measurement times (same for each individual, unless
\code{t_jitter > 0} in which case they are perturbed).}

\item{t_jitter}{Standard deviation of the jitter added to the given
measurement times.}

\item{t_effect_range}{Time interval from which the disease effect times are
sampled uniformly. Alternatively, This can any function that returns the
(possibly randomly generated) real disease effect time for one individual.}

\item{continuous_info}{Info for generating continuous covariates. Must be a
list containing fields \code{lambda} and \code{mu}, which have length 3.
The continuous covariates are generated so that \code{x <- sin(a*t + b) + c},
where
\itemize{
  \item \code{t <- seq(0, 2*pi, length.out = k)}
  \item \code{a <- mu[1] + lambda[1]*stats::runif(1)}
  \item \code{b <- mu[2] + lambda[2]*stats::runif(1)}
  \item \code{c <- mu[3] + lambda[3]*stats::runif(1)}
}}
}
\value{
a list
}
\description{
Create an input data frame X for simulated data
}
