% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{gpcov}
\alias{gpcov}
\title{Conditional covariance of Gaussian process given observations}
\usage{
gpcov(yobs, tvec, tnew, phi, sigma, kerneltype = "generalMatern")
}
\arguments{
\item{yobs}{vector of observations}

\item{tvec}{vector of time points corresponding to observations}

\item{tnew}{vector of time points at which the conditional covariance should be computed}

\item{phi}{vector of hyper-parameters for the covariance kernel (\code{kerneltype})}

\item{sigma}{the noise level (if known). By default, both \code{phi} and \code{sigma} are estimated. If a value for \code{sigma} is supplied, then \code{sigma} is held fixed at the supplied value and only \code{phi} is estimated.}

\item{kerneltype}{the covariance kernel, types \code{matern}, \code{rbf}, \code{compact1}, \code{periodicMatern}, \code{generalMatern} are supported.  See \code{\link{calCov}} for their definitions.}
}
\value{
The conditional covariance matrix for the GP evaluated at the time points in \code{tnew}.
}
\description{
Compute the conditional covariance of a Gaussian process, given a vector of observations, hyper-parameters \code{phi}, and noise standard deviation \code{sigma}.
}
\examples{
# Load Fitzhugh-Nagumo dataset
data(FNdat)

tnew <- seq(15, 20, by = 0.5)

# GP covariance of V component at time points in tnew given observations
gpcov(FNdat$V, FNdat$time, tnew, c(2.3, 1.2), 0.2)

}
