% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turf.R
\name{turf_voronoi}
\alias{turf_voronoi}
\title{Create Voronoi diagram}
\usage{
turf_voronoi(
  map,
  layer_id = NULL,
  data = NULL,
  coordinates = NULL,
  bbox = NULL,
  property = NULL,
  source_id,
  input_id = NULL
)
}
\arguments{
\item{map}{A mapboxgl, maplibre, mapboxgl_proxy, or maplibre_proxy object.}

\item{layer_id}{The ID of a layer or source containing points (mutually exclusive with data and coordinates).}

\item{data}{An sf object containing points (mutually exclusive with layer_id and coordinates).}

\item{coordinates}{A list of coordinate pairs list(c(lng,lat), c(lng,lat), ...) for multiple points (mutually exclusive with layer_id and data).}

\item{bbox}{Optional. Can be: (1) A numeric vector of length 4, in format `c(xmin, ymin, xmax, ymax)', (2) An sf object to extract bbox from, or (3) A layer_id string to extract bbox from and clip results to.}

\item{property}{Optional. Character string specifying a column name from the input points to transfer to the Voronoi polygons using spatial collection.}

\item{source_id}{The ID for the new source containing the Voronoi diagram. Required.}

\item{input_id}{Optional. Character string specifying the Shiny input ID suffix for storing results. If NULL (default), no input is registered. For proxy operations, the result will be available as \code{input[[paste0(map_id, "_turf_", input_id)]]}.}
}
\value{
The map or proxy object for method chaining.
}
\description{
This function creates a Voronoi diagram from a set of points.
The result is added as a source to the map, which can then be styled using add_fill_layer(), etc.
}
