% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecover_area_and_emissions.R
\name{treecover_area_and_emissions}
\alias{treecover_area_and_emissions}
\alias{calc_treecover_area_and_emissions}
\title{Calculate treeloss statistics}
\usage{
calc_treecover_area_and_emissions(
  years = 2000:2023,
  min_size = 10,
  min_cover = 35
)
}
\arguments{
\item{years}{A numeric vector with the years for which to calculate treecover
area and emissions.}

\item{min_size}{The minimum size of a forest patch in ha.}

\item{min_cover}{The minimum threshold of stand density for a pixel to be
considered forest in the year 2000.}
}
\value{
A function that returns an indicator tibble with variables treecover
and emissions and corresponding values (in ha and Mg) as value.
}
\description{
This functions allows to efficiently calculate the treecover and emissions
indicators in a single function call together. Since most of the pre-processing
operations for treecover and emissions are the same, it is more efficient
to calculate them in one run if users are actually interested in both statistics.
Otherwise users are advised to use the respective single indicator functions.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
\item \link{gfw_emissions}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(
    get_gfw_treecover(version = "GFC-2023-v1.11"),
    get_gfw_lossyear(version = "GFC-2023-v1.11"),
    get_gfw_emissions()
  ) \%>\%
  calc_indicators(
    calc_treecover_area_and_emissions(years = 2016:2017, min_size = 1, min_cover = 30)
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
