% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_treecoverloss_emissions.R
\name{treecoverloss_emissions}
\alias{treecoverloss_emissions}
\alias{calc_treecoverloss_emissions}
\title{Calculate emission statistics}
\usage{
calc_treecoverloss_emissions(years = 2000:2023, min_size = 10, min_cover = 35)
}
\arguments{
\item{years}{A numeric vector with the years for which to calculate emissions
caused by treecover loss.}

\item{min_size}{The minimum size of a forest patch in ha.}

\item{min_cover}{The minimum threshold of stand density for a pixel to be
considered forest in the year 2000.}
}
\value{
A function that returns an indicator tibble with emissions as variable
and emitted CO2 equivalent (in Mg) as value.
}
\description{
This functions allows to efficiently calculate emission statistics for
areas of interest. For each year in the analysis timeframe, the forest losses
from Hansen et al. (2013) are overlayed with the respective emission layer
from Harris et al. (2021) and area-wise emission statistics are calculated
for each year.
}
\details{
The required resources for this indicator are:
\itemize{
\item \link{gfw_treecover}
\item \link{gfw_lossyear}
\item \link{gfw_emissions}
}
}
\examples{
\dontshow{
mapme.biodiversity:::.copy_resource_dir(file.path(tempdir(), "mapme-data"))
}
\dontrun{
library(sf)
library(mapme.biodiversity)

outdir <- file.path(tempdir(), "mapme-data")
dir.create(outdir, showWarnings = FALSE)

mapme_options(
  outdir = outdir,
  verbose = FALSE
)

aoi <- system.file("extdata", "sierra_de_neiba_478140_2.gpkg",
  package = "mapme.biodiversity"
) \%>\%
  read_sf() \%>\%
  get_resources(
    get_gfw_treecover(version = "GFC-2023-v1.11"),
    get_gfw_lossyear(version = "GFC-2023-v1.11"),
    get_gfw_emissions()
  ) \%>\%
  calc_indicators(
    calc_treecoverloss_emissions(years = 2016:2017, min_size = 1, min_cover = 30)
  ) \%>\%
  portfolio_long()

aoi
}
}
\keyword{indicator}
