% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.R
\name{annotate}
\alias{annotate}
\alias{annotate_row}
\alias{annotate_column}
\title{Create/modify/delete annotations of a \code{matrixset} object}
\usage{
annotate_row(.ms, ...)

annotate_column(.ms, ...)
}
\arguments{
\item{.ms}{A \code{matrixset} object.}

\item{...}{Name-value pairs, ala \code{dplyr}'s \code{\link[dplyr:mutate]{dplyr::mutate()}}.}
}
\value{
A \code{matrixset} with updated meta info.
}
\description{
An annotation is a trait that is stored in the meta (row or column) data frame
of the \code{.ms} object.

Creating an annotation is done as when applying a \code{mutate()} on a data frame.
Thus, annotations can be created from already existing annotations.

The usage is the same as for \code{\link[dplyr:mutate]{dplyr::mutate()}}, so see this function for
instructions on how to create/modify or delete traits.

The only difference is that the tag is a special annotation that can't be
deleted or modify (with one exception in case of modification). The tag is
the column name of the meta data frame that holds the row or column names.
The tag identity of the' object can be obtained via \code{\link[=row_tag]{row_tag()}} or
\code{\link[=column_tag]{column_tag()}}. To modify a tag, see \verb{rownames<-()} or \verb{colnames<-()}.
}
\examples{
# You can create annotation from scrath or using already existing annotation
ms <- annotate_row(student_results,
                   dummy = 1,
                   passed = ifelse(previous_year_score >= 0.6, TRUE, FALSE))

# There is a direct access to matrix content with annotate_row_from_apply(),
# but here is an example on how it can be done with annotate_row()
ms <- annotate_row(student_results,
                   mn_fail = apply_matrix_dfl(student_results, mn=~ rowMeans(.m1),
                                              .matrix_wise = FALSE)$mn)

}
\seealso{
\code{\link[=annotate_row_from_apply]{annotate_row_from_apply()}}/\code{\link[=annotate_column_from_apply]{annotate_column_from_apply()}}, a version that
allows access to the \code{matrixset} matrices.
}
