% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m2-methods.R
\name{fit_m2.measrdcm}
\alias{fit_m2.measrdcm}
\title{Estimate the \ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} fit statistic for
diagnostic classification models}
\usage{
\method{fit_m2}{measrdcm}(model, ..., ci = 0.9, force = FALSE)
}
\arguments{
\item{model}{An estimated diagnostic classification model.}

\item{...}{Unused, for extensibility.}

\item{ci}{The confidence interval for the RMSEA.}

\item{force}{If the \ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} has already
been saved to the model object with \code{\link[=add_fit]{add_fit()}}, should it be recalculated.
Default is \code{FALSE}.}
}
\value{
A data frame created by \code{\link[dcm2:fit_m2]{dcm2::fit_m2()}}.
}
\description{
For diagnostic classification models, the
\ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} statistic is calculated as
described by Hansen et al. (2016) and Liu et al. (2016).
}
\section{Methods (by class)}{
\itemize{
\item \code{fit_m2(measrdcm)}: \ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} for
diagnostic classification models.

}}
\examples{
\dontshow{if (measr_examples()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
rstn_mdm_lcdm <- measr_dcm(
  data = mdm_data, missing = NA, qmatrix = mdm_qmatrix,
  resp_id = "respondent", item_id = "item", type = "lcdm",
  method = "optim", seed = 63277, backend = "rstan"
)

fit_m2(rstn_mdm_lcdm)
\dontshow{\}) # examplesIf}
}
\references{
Hansen, M., Cai, L., Monroe, S., & Li, Z. (2016).
Limited-information goodness-of-fit testing of diagnostic classification
item response models. \emph{British Journal of Mathematical and Statistical
Psychology, 69}(3), 225-252. \doi{10.1111/bmsp.12074}

Liu, Y., Tian, W., & Xin, T. (2016). An application of
\ifelse{html}{\out{M<sub>2</sub>}}{\eqn{M_2}} statistic to evaluate the fit
of cognitive diagnostic models. \emph{Journal of Educational and Behavioral
Statistics, 41}(1), 3-26. \doi{10.3102/1076998615621293}
}
