% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lthill.R
\name{shape.trimhill}
\alias{shape.trimhill}
\title{Trimmed Hill estimator for the shape parameter}
\usage{
shape.trimhill(xdat, k, k0, sorted = FALSE)
}
\arguments{
\item{xdat}{[numeric] vector of positive observations}

\item{k}{[integer] number of order statistics for the threshold}

\item{k0}{[integer] number of largest order statistics, strictly less than \code{k}}

\item{sorted}{[logical] if \code{TRUE}, data are assumed to be sorted in decreasing order}
}
\value{
a scalar with the shape parameter estimate
}
\description{
Given a sample of Pareto-tailed samples (positive tail index),
compute the trimmed Hill estimator. If \eqn{k0=k}, the estimator
reduces to Hill's estimator for the shape index
}
\references{
Bhattacharya, S., Kallitsis, M. and S. Stoev, (2019) Data-adaptive trimming of the Hill estimator and detection of outliers in the extremes of heavy-tailed data. Electronic Journal of Statistics 13, 1872–1925
}
