% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-client.R
\name{mlflow_client_set_tag}
\alias{mlflow_client_set_tag}
\title{Set Tag}
\usage{
mlflow_client_set_tag(client, run_id, key, value)
}
\arguments{
\item{client}{An `mlflow_client` object.}

\item{run_id}{Run ID.}

\item{key}{Name of the tag. Maximum size is 255 bytes. This field is required.}

\item{value}{String value of the tag being logged. Maximum size is 500 bytes. This field is required.}
}
\description{
Set a tag on a run. Tags are run metadata that can be updated during and
 after a run completes.
}
\details{
The Tracking Client family of functions require an MLflow client to be
  specified explicitly. These functions allow for greater control of where the
  operations take place in terms of services and runs, but are more verbose
  compared to the Fluent API.
}
\seealso{
Other Tracking client functions: \code{\link{mlflow_client_create_experiment}},
  \code{\link{mlflow_client_create_run}},
  \code{\link{mlflow_client_delete_experiment}},
  \code{\link{mlflow_client_delete_run}},
  \code{\link{mlflow_client_download_artifacts}},
  \code{\link{mlflow_client_get_experiment_by_name}},
  \code{\link{mlflow_client_get_experiment}},
  \code{\link{mlflow_client_get_run}},
  \code{\link{mlflow_client_list_artifacts}},
  \code{\link{mlflow_client_list_experiments}},
  \code{\link{mlflow_client_log_artifact}},
  \code{\link{mlflow_client_log_metric}},
  \code{\link{mlflow_client_log_param}},
  \code{\link{mlflow_client_restore_experiment}},
  \code{\link{mlflow_client_restore_run}},
  \code{\link{mlflow_client_set_terminated}}
}
\concept{Tracking client functions}
\keyword{internal}
