% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-runs.R
\name{mlflow_log_metric}
\alias{mlflow_log_metric}
\title{Log Metric}
\usage{
mlflow_log_metric(key, value, timestamp = NULL, step = NULL,
  run_id = NULL, client = NULL)
}
\arguments{
\item{key}{Name of the metric.}

\item{value}{Float value for the metric being logged.}

\item{timestamp}{Timestamp at which to log the metric. Timestamp is rounded to the nearest
integer. If unspecified, the number of milliseconds since the Unix epoch is used.}

\item{step}{Step at which to log the metric. Step is rounded to the nearest integer. If
unspecified, the default value of zero is used.}

\item{run_id}{Run ID.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Logs a metric for a run. Metrics key-value pair that records a single float measure.
  During a single execution of a run, a particular metric can be logged several times.
  The MLflow Backend keeps track of historical metric values along two axes: timestamp and step.
}
