% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorganise_matrices.R
\name{reorganise_matrices}
\alias{reorganise_matrices}
\title{Reorganise Matrix Population Models}
\usage{
reorganise_matrices(matrix_list)
}
\arguments{
\item{matrix_list}{A list of lists, where each sub-list contains the matrices
\code{mat_A}, \code{mat_U}, \code{mat_F}, and optionally \code{mat_C}.}
}
\value{
A list containing four elements: \code{mat_A}, \code{mat_U},
\code{mat_F}, and \code{mat_C}. Each element is a list of matrices
corresponding to the respective matrix type from the input. If \code{mat_C}
does not exist in a sub-list, it is replaced with an \code{NA} matrix of
the same dimensions as \code{mat_U}.
}
\description{
This function reorganises a list of matrix population models, which are split
into \code{mat_A}, \code{mat_U}, \code{mat_F}, and optionally \code{mat_C}
sub-matrices. It prepares the matrices for easy conversion into a
\code{compadreDB} object.
}
\details{
This function processes a list of matrix population models,
extracting and grouping the sub-matrices (\code{mat_A}, \code{mat_U},
\code{mat_F}, and optionally \code{mat_C}) into separate lists. If a
\code{mat_C} matrix is not present in a model, an \code{NA} matrix of the
same size as \code{mat_U} is used as a placeholder.
}
\examples{
# Example usage
matrix_list <- list(
  list(
    mat_A = matrix(1, 2, 2),
    mat_U = matrix(2, 2, 2),
    mat_F = matrix(3, 2, 2),
    mat_C = matrix(4, 2, 2)
  ),
  list(
    mat_A = matrix(5, 2, 2),
    mat_U = matrix(6, 2, 2),
    mat_F = matrix(7, 2, 2)
  )
)
reorganised_matrices <- reorganise_matrices(matrix_list)
reorganised_matrices$mat_A
}
\seealso{
Other Leslie matrices: 
\code{\link{make_leslie_mpm}()},
\code{\link{rand_leslie_set}()}
}
\author{
Owen Jones \href{mailto:jones@biology.sdu.dk}{jones@biology.sdu.dk}
}
\concept{Leslie matrices}
