% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\name{WAIC}
\alias{WAIC}
\title{Watanabe-Akaike or Widely Available Information Criterion (WAIC)}
\usage{
WAIC(..., verbose = TRUE, digits = max(3, getOption("digits") - 2))
}
\arguments{
\item{...}{one or several objects of the class \emph{mtar}.}

\item{verbose}{an (optional) logical switch indicating if should the report of results be printed. By default,\code{verbose} is set to TRUE.}

\item{digits}{an (optional) integer indicating the number of digits to print. By default,\code{digits} is set to \code{max(3, getOption("digits") - 2)}.}
}
\value{
A \code{data.frame} with the values of the WAIC for each \emph{mtar} object in the input.
}
\description{
This function computes the Watanabe-Akaike or Widely Available Information Criterion (WAIC) for objects of class \code{mtar}.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1a <- mtar(~ COLCAP + BOVESPA | SP500, data=returns, row.names=Date,
              dist="Gaussian", ars=list(p=c(1,1,2)), n.burnin=100,
              n.sim=3000, n.thin=2)
fit1b <- update(fit1a,dist="Slash")
fit1c <- update(fit1a,dist="Student-t")
WAIC(fit1a,fit1b,fit1c)

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2a <- mtar(~ Bedon + LaPlata | Rainfall, data=riverflows, row.names=Date,
              dist="Gaussian", ars=list(p=c(5,5,5)), n.burnin=100,
              n.sim=3000, n.thin=2)
fit2b <- update(fit2a,dist="Slash")
fit2c <- update(fit2a,dist="Student-t")
WAIC(fit2a,fit2b,fit2c)
}

}
\references{
Watanabe S. (2010). Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in
            Singular Learning Theory. The Journal of Machine Learning Research, 11, 3571–3594.
}
\seealso{
\link{DIC}
}
