% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Misc.R
\name{findQuantile}
\alias{findQuantile}
\title{Find quantiles of the original data.}
\usage{
findQuantile(Y,
            X,
            X_bin,
            probs=c(0.1,0.5,0.9),...)
}
\arguments{
\item{Y}{A numeric vector whose sample quantiles are wanted.}

\item{X}{A numeric vector corresponding to Y.}

\item{X_bin}{Binning result from makeCOVbin function.}

\item{probs}{A numeric vector of probabilities.}

\item{...}{Arguments to be passed to methods.}
}
\value{
quantiles of Y using X_bin
}
\description{
Find quantiles of the original data.
}
\examples{
data(origdata)
CUT = FindBestCut(origdata$TIME,8)$cutoffs
time_bin = makeCOVbin(origdata$TIME,K=8,cutoffs = CUT)
findQuantile(origdata$DV,origdata$TIME,X_bin=time_bin)
}
