% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_paired_baseline_contrasts.R
\name{dig_paired_baseline_contrasts}
\alias{dig_paired_baseline_contrasts}
\title{Search for conditions that provide significant differences between paired
variables}
\usage{
dig_paired_baseline_contrasts(
  x,
  condition = where(is.logical),
  xvars = where(is.numeric),
  yvars = where(is.numeric),
  disjoint = var_names(colnames(x)),
  min_length = 0L,
  max_length = Inf,
  min_support = 0,
  max_support = 1,
  method = "t",
  alternative = "two.sided",
  h0 = 0,
  conf_level = 0.95,
  max_p_value = 1,
  t_var_equal = FALSE,
  wilcox_exact = FALSE,
  wilcox_correct = TRUE,
  wilcox_tol_root = 1e-04,
  wilcox_digits_rank = Inf,
  max_results = Inf,
  verbose = FALSE,
  threads = 1
)
}
\arguments{
\item{x}{a matrix or data frame with data to search the patterns in.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{xvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of contrasts}

\item{yvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of contrasts}

\item{disjoint}{an atomic vector of size equal to the number of columns of \code{x}
that specifies the groups of predicates: if some elements of the \code{disjoint}
vector are equal, then the corresponding columns of \code{x} will NOT be
present together in a single condition. If \code{x} is prepared with
\code{\link[=partition]{partition()}}, using the \code{\link[=var_names]{var_names()}} function on \code{x}'s column names
is a convenient way to create the \code{disjoint} vector.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the
empty condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of
conditions is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{max_support}{the maximum support of a condition to trigger the callback
function for it. See argument \code{min_support} for details of what is the
support of a condition.}

\item{method}{a character string indicating which contrast to compute.
One of \code{"t"}, for parametric, or \code{"wilcox"}, for non-parametric test on
equality in position.}

\item{alternative}{indicates the alternative hypothesis and must be one of
\code{"two.sided"}, \code{"greater"} or \code{"less"}. \code{"greater"} corresponds to
positive association, \code{"less"} to negative association.}

\item{h0}{a numeric value specifying the null hypothesis for the test. For
the \code{"t"} method, it is the difference in means. For the \code{"wilcox"} method,
it is the difference in medians. The default value is 0.}

\item{conf_level}{a numeric value specifying the level of the confidence
interval. The default value is 0.95.}

\item{max_p_value}{the maximum p-value of a test for the pattern to be considered
significant. If the p-value of the test is greater than \code{max_p_value}, the
pattern is not included in the result.}

\item{t_var_equal}{(used for the \code{"t"} method only) a logical value indicating
whether the variances of the two samples are assumed to be equal. If
\code{TRUE}, the pooled variance is used to estimate the variance in the t-test.
If \code{FALSE}, the Welch (or Satterthwaite) approximation to the degrees of
freedom is used. See \code{\link[=t.test]{t.test()}} and its \code{var.equal} argument for more
information.}

\item{wilcox_exact}{(used for the \code{"wilcox"} method only) a logical value
indicating whether the exact p-value should be computed. If \code{NULL}, the
exact p-value is computed for sample sizes less than 50. See \code{\link[=wilcox.test]{wilcox.test()}}
and its \code{exact} argument for more information. Contrary to the behavior
of \code{\link[=wilcox.test]{wilcox.test()}}, the default value is \code{FALSE}.}

\item{wilcox_correct}{(used for the \code{"wilcox"} method only) a logical value
indicating whether the continuity correction should be applied in the
normal approximation for the p-value, if \code{wilcox_exact} is \code{FALSE}. See
\code{\link[=wilcox.test]{wilcox.test()}} and its \code{correct} argument for more information.}

\item{wilcox_tol_root}{(used for the \code{"wilcox"} method only) a numeric value
specifying the tolerance for the root-finding algorithm used to compute
the exact p-value. See \code{\link[=wilcox.test]{wilcox.test()}} and its \code{tol.root} argument for
more information.}

\item{wilcox_digits_rank}{(used for the \code{"wilcox"} method only) a numeric value
specifying the number of digits to round the ranks to. See \code{\link[=wilcox.test]{wilcox.test()}}
and its \code{digits.rank} argument for more information.}

\item{max_results}{the maximum number of generated conditions to execute the
callback function on. If the number of found conditions exceeds
\code{max_results}, the function stops generating new conditions and returns
the results. To avoid long computations during the search, it is recommended
to set \code{max_results} to a reasonable positive value. Setting \code{max_results}
to \code{Inf} will generate all possible conditions.}

\item{verbose}{a logical scalar indicating whether to print progress messages.}

\item{threads}{the number of threads to use for parallel computation.}
}
\value{
A tibble with found patterns in rows. The following columns are always
present:
\item{condition}{the condition of the pattern as a character string
in the form \code{{p1 & p2 & ... & pn}} where \code{p1}, \code{p2}, ..., \code{pn} are
\code{x}'s column names.}
\item{support}{the support of the condition, i.e., the relative
frequency of the condition in the dataset \code{x}.}
\item{xvar}{the name of the first variable in the contrast.}
\item{yvar}{the name of the second variable in the contrast.}
\item{estimate}{the estimated difference of variable \code{var}.}
\item{statistic}{the statistic of the selected test.}
\item{p_value}{the p-value of the underlying test.}
\item{n}{the number of rows in the sub-data corresponding to
the condition.}
\item{conf_int_lo}{the lower bound of the confidence interval of the estimate.}
\item{conf_int_hi}{the upper bound of the confidence interval of the estimate.}
\item{alternative}{a character string indicating the alternative
hypothesis. The value must be one of \code{"two.sided"}, \code{"greater"}, or
\code{"less"}.}
\item{method}{a character string indicating the method used for the
test.}
\item{comment}{a character string with additional information about the
test (mainly error messages on failure).}
For the \code{"t"} method, the following additional columns are also
present (see also \code{\link[=t.test]{t.test()}}):
\item{df}{the degrees of freedom of the t test.}
\item{stderr}{the standard error of the mean difference.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Paired baseline contrast patterns identify conditions under which there is
a significant difference in some statistical feature between two paired
numeric variables.

\describe{
\item{Scheme:}{\code{(xvar - yvar) != 0 | C}\cr\cr
There is a statistically significant difference between paired variables
\code{xvar} and \code{yvar} under the condition \code{C}.}
\item{Example:}{\code{(daily_ice_cream_income - daily_tea_income) > 0 | sunny}\cr\cr
Under the condition of \emph{sunny weather}, the paired test shows that
\emph{daily ice-cream income} is significantly higher than the
\emph{daily tea income}.}
}

The paired baseline contrast  is computed using a paired version of a statistical test,
which is specified by the \code{method} argument. The function computes the paired
contrast between all pairs of variables, where the first variable is
specified by the \code{xvars} argument and the second variable is specified by the
\code{yvars} argument. Paired baseline contrasts are computed in sub-data corresponding
to conditions generated from the \code{condition} columns. Function
\code{dig_paired_baseline_contrasts()} supports crisp conditions only, i.e.,
the condition columns in \code{x} must be logical.
}
\examples{
# Compute ratio of sepal and petal length and width for iris dataset
crispIris <- iris
crispIris$Sepal.Ratio <- iris$Sepal.Length / iris$Sepal.Width
crispIris$Petal.Ratio <- iris$Petal.Length / iris$Petal.Width

# Create predicates from the Species column
crispIris <- partition(crispIris, Species)

# Compute paired contrasts for ratios of sepal and petal length and width
dig_paired_baseline_contrasts(crispIris,
                              condition = where(is.logical),
                              xvars = Sepal.Ratio,
                              yvars = Petal.Ratio,
                              method = "t",
                              min_support = 0.1)
}
\seealso{
\code{\link[=dig_baseline_contrasts]{dig_baseline_contrasts()}}, \code{\link[=dig_complement_contrasts]{dig_complement_contrasts()}},
\code{\link[=dig]{dig()}}, \code{\link[=dig_grid]{dig_grid()}},
\code{\link[stats:t.test]{stats::t.test()}}, \code{\link[stats:wilcox.test]{stats::wilcox.test()}}
}
\author{
Michal Burda
}
