% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{example_shortterm_future_predictions}
\alias{example_shortterm_future_predictions}
\title{Example Shortterm Future Predictions Data}
\format{
A data frame with 105,120 rows and 40 columns:
\describe{
\item{\code{country}}{The country, represented by the ISO2C country code (e.g., \code{FR} for France).}
\item{\code{date}}{The date (in \code{YYYY-MM-DD} format).}
\item{\code{year}}{The respective year.}
\item{\code{month}}{The respective month.}
\item{\code{day}}{The respective day.}
\item{\code{wday}}{The type of weekday (e.g., \code{Sun}, \code{Mon})}
\item{\code{hour}}{The respective hour of the day.}
\item{\code{hourly_demand}}{The actual hourly electricity demand (in megawatts).}
\item{\code{hourly_demand_trend_corrected}}{The hourly demand corrected for long-term trends.}
\item{\code{yearly}}{The yearly average electricity demand.}
\item{\code{daily}}{The daily average electricity demand.}
\item{\code{hourly_demand_trend_and_season_corrected}}{The hourly demand corrected for both long-term trends and seasonal variations.}
\item{\code{holiday}}{A binary indicator for whether the day is a public holiday (\code{1} for holiday, \code{0} for non-holiday).}
\item{\code{Hour0}, \code{Hour1}, \code{Hour2}, \code{Hour3}, \code{Hour4}, \code{Hour5}, \code{Hour6}, \code{Hour7}, \code{Hour8}, \code{Hour9}, \code{Hour10}, \code{Hour11}, \code{Hour12}, \code{Hour13}, \code{Hour14}, \code{Hour15}, \code{Hour16}, \code{Hour17}, \code{Hour18}, \code{Hour19}, \code{Hour20}, \code{Hour21}, \code{Hour22}, \code{Hour23}}{Binary variables indicating the hour of the day, where each variable represents a specific hour (e.g., \code{Hour0} for 00:00 to 00:59, \code{Hour1} for 01:00 to 01:59, and so on up to \code{Hour23} for 23:00 to 23:59).}
\item{\code{short_term_lm_model_predictions}}{Model predictions for the short-term seasonality (the intraday pattern).}
\item{\code{test_set_steps}}{Number of hours used in the test set for model evaluation.}
\item{\code{example}}{A boolean indicator to mark this dataset as an example dataset.}
}
}
\source{
demand data: Transparency Platform of the European Network of
Transmission System Operators for Electricity (ENTSO-E, https://transparency.entsoe.eu/);
holidays: https://date.nager.at/api/v3/publicholidays/
}
\usage{
example_shortterm_future_predictions
}
\description{
This dataset extends the short-term electricity demand predictions from \code{\link{example_shortterm_predictions}} until the year 2028.
}
\keyword{dataset}
\keyword{future}
\keyword{prediction}
\keyword{shortterm}
