% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yield_monitor.R
\name{pa_apportion_mass}
\alias{pa_apportion_mass}
\title{Impose a regular grid over yield polygons}
\usage{
pa_apportion_mass(
  polygons,
  mass.vector,
  cell.size = NULL,
  sum = FALSE,
  remove.empty.cells = TRUE,
  cores = 1L,
  verbose = FALSE
)
}
\arguments{
\item{polygons}{sf object containing polygon geometries}

\item{mass.vector}{a vector of mass observations}

\item{cell.size}{optional numerical value (length 1) to
be used as the width and height of the grid}

\item{sum}{whether the apportioned values should be
added together. This is useful in the case of
overlaping polygons that have an additive effect. For
example, polygons representing seeding rates.}

\item{remove.empty.cells}{logical. Whether to remove
empty cells, with NA values.}

\item{cores}{the number of cores used in the operation}

\item{verbose}{whether to print operation details}
}
\value{
sf object
}
\description{
Impose a regular grid over yield polygons
}
\details{
This function will impose a regular grid over
  the yield polygons and compute the weighted average of
  the mass value represented by each polygon. The
  averages are weighted according to the polygon area.
}
\examples{
\donttest{
## for examples, see vignette pacu
}

}
\author{
Caio dos Santos and Fernando Miguez
}
