% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasource.R
\name{ds_read}
\alias{ds_read}
\title{Get data for a resource type from a data source}
\usage{
ds_read(ds, resource_code)
}
\arguments{
\item{ds}{The DataSource object.}

\item{resource_code}{A string representing the type of FHIR resource to read data from.}
}
\value{
A Spark DataFrame containing the data for the given resource type.
}
\description{
Get data for a resource type from a data source
}
\examples{
\dontshow{if (pathling_is_spark_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
pc <- pathling_connect()
data_source <- pc \%>\% pathling_read_ndjson(pathling_examples('ndjson'))
data_source \%>\% ds_read('Patient') \%>\% sparklyr::sdf_nrow()
data_source \%>\% ds_read('Condition') \%>\% sparklyr::sdf_nrow()
pathling_disconnect(pc)
\dontshow{\}) # examplesIf}
}
