% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_direct_match.R
\name{direct_match}
\alias{direct_match}
\title{Direct Match Species Names Against Peru Mammals Database}
\usage{
direct_match(df, target_df = NULL)
}
\arguments{
\item{df}{A data frame or tibble containing the species data to be matched.
Must include columns: Orig.Genus, Orig.Species, Rank}

\item{target_df}{A data frame representing the peru_mammals database.
Must include columns: genus, species}
}
\value{
A tibble with an additional logical column \code{direct_match} indicating whether
the name was successfully matched (\code{TRUE}) or not (\code{FALSE}), plus columns
\code{Matched.Genus} and \code{Matched.Species} for matched records.
}
\description{
Performs direct matching of species names against the peru_mammals database.
Matches binomial names (genus + species) and handles special "sp." cases
(e.g., "Akodon sp. Ancash"). Peru mammals database does not include
infraspecific taxa.
}
\details{
This function only matches Rank 2 (binomial) names since peru_mammals does
not include infraspecific taxa. It handles:
\itemize{
\item Regular binomials: "Panthera onca"
\item Special "sp." cases: "Akodon sp. Ancash", "Oligoryzomys sp. B"
}

Names at Rank 1 (genus only) are not matched by this function; use
\code{genus_match()} instead.
}
\keyword{internal}
