% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald.R
\name{pgsc.wald.test}
\alias{pgsc.wald.test}
\title{A wrapper for the wald test of a restricted solution}
\usage{
pgsc.wald.test(dta, dep.var, indep.var, sol.rest, n.boot = 10000,
  seed = 42)
}
\arguments{
\item{dta}{A dataframe}

\item{dep.var}{A vector of strings of names of dependent variables.}

\item{indep.var}{A vector of strings of names of independent (treatment) variables.}

\item{sol.rest}{A restricted solution which is being tested}

\item{n.boot}{The number of bootstrapped samples for the variance calculation. Default is 10000.}

\item{seed}{Randomization seed.  Default is 42.}
}
\value{
Returns the wald test as \code{gsc.wald} object, a list with entries:
\describe{
    \item{b}{The point estimate of the coefficients on the dependent variables}
    \item{S}{The Wald statistic}
    \item{s.boot}{The bootstrapped Wald statistic}
    \item{p.value}{The p-value for the Wald statistic.}
}
}
\description{
A wrapper for the wald test of a restricted solution
}
\details{
See the vignette "Using \code{pgsc}" for an extended example.
}
\examples{
data("pgsc.dta")
g.i <- function(b) b[1] ; g.i.grad <- function(b) c(1,0)
sol.r <- pgsc(pgsc.dta, dep.var = 'y', indep.var = c('D1','D2'), 
b.init = c(0,1), method='onestep', g.i=g.i, g.i.grad=g.i.grad )
wald <- pgsc.wald.test( pgsc.dta, 'y', indep.var = c('D1','D2'), sol.r )
summary(wald)
plot(wald)
}
