% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.trim.r
\name{clip_wl}
\alias{clip_wl}
\alias{clip_wl.default}
\alias{clip_wl.generic_spct}
\alias{clip_wl.generic_mspct}
\alias{clip_wl.waveband}
\alias{clip_wl.list}
\title{Clip head and/or tail of a spectrum}
\usage{
clip_wl(x, range, ...)

\method{clip_wl}{default}(x, range, ...)

\method{clip_wl}{generic_spct}(x, range = NULL, ...)

\method{clip_wl}{generic_mspct}(x, range = NULL, expand = TRUE, ...)

\method{clip_wl}{waveband}(x, range = NULL, ...)

\method{clip_wl}{list}(x, range = NULL, ...)
}
\arguments{
\item{x}{an R object.}

\item{range}{a numeric vector of length two, or any other object for which
function \code{range()} will return range of wavelengths expressed in
nanometres.}

\item{...}{ignored (possibly used by derived methods).}

\item{expand}{logical Expand or not members containing spectra in long form.}
}
\value{
a spectrum object or a collection of spectral objects of the same
  class as \code{x} with wavelength heads and tails clipped.
}
\description{
Clip head and tail of a spectrum based on wavelength limits, no
interpolation used at range boundaries.
}
\section{Methods (by class)}{
\itemize{
\item \code{clip_wl(default)}: Default for generic function

\item \code{clip_wl(generic_spct)}: Clip an object of class "generic_spct" or derived.

\item \code{clip_wl(generic_mspct)}: Clip an object of class "generic_mspct" or derived.

\item \code{clip_wl(waveband)}: Clip an object of class "waveband".

\item \code{clip_wl(list)}: Clip a list (of objects of class "waveband").

}}
\note{
The condition tested is \code{wl >= range[1] & wl < (range[2] + 1e-13)}.
}
\examples{
clip_wl(sun.spct, range = c(400, 500))
clip_wl(sun.spct, range = c(NA, 500))
clip_wl(sun.spct, range = c(400, NA))

}
\seealso{
Other trim functions: 
\code{\link{trim_spct}()},
\code{\link{trim_waveband}()},
\code{\link{trim_wl}()}
}
\concept{trim functions}
