% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.spectrum.r
\name{interpolate_spectrum}
\alias{interpolate_spectrum}
\title{Calculate spectral values at a different set of wavelengths}
\usage{
interpolate_spectrum(
  w.length.in,
  s.irrad,
  w.length.out,
  fill = NA,
  method = "approx",
  ...
)
}
\arguments{
\item{w.length.in}{numeric vector of wavelengths (nm).}

\item{s.irrad}{a numeric vector of spectral values.}

\item{w.length.out}{numeric vector of wavelengths (nm).}

\item{fill}{a numeric value to be assigned to out of range wavelengths.}

\item{method}{character string One of \code{"auto"}, \code{"approx"},
\code{"spline"}, \code{"skip"}.}

\item{...}{additional arguments passed to \code{spline()}.}
}
\value{
a numeric vector of interpolated spectral values.
}
\description{
Interpolate/re-express spectral irradiance (or other spectral quantity)
values at new wavelengths values. This is a low-level function operating
on numeric vectors and called by higher level functions in the package,
such as mathematical operators for classes for spectral data.
}
\details{
Depending on \code{method} natural spline interpolation or linear
  interpolation are used. With \code{method = spline} a call to
  \code{\link[stats:splinefun]{spline}} with \code{method = "natural"} is
  used and with \code{method = "approx"} a call to
  \code{\link[stats:approxfun]{approx}} is used. If \code{method = "auto"} or
  \code{method = NULL} when 100 or fewer distinct wavelengths are available
  as input and/or the maximum wavelength step size in \code{w.length.in} is
  more than three times the minimum wavelength step size in
  \code{w.length.out} \code{"spline"} is used and \code{"approx"} otherwise.
  Finally, with \code{method = "skip"} the input is returned unchanged.

  If \code{w.length.out} is a numeric vector and \code{length.out = NULL}, it
  directly gives the target wavelengths for interpolation. If it is
  \code{NULL}, and \code{length.out} is an integer value evenly spaced
  wavelength values covering the same wavelength range as in the input are
  generated. If \code{w.length.out} is a numeric vector and \code{length.out}
  is an integer value, \code{length.out} evenly spaced wavelengths covering
  the wavelength range of \code{w.length.out} are generated.
  \emph{Extrapolation is not supported.}

  With default \code{fill = NA} if the output exceeds the wavelength range of
  the input, extrapolated values are filled with \code{NA} values. With
  \code{fill = NULL} wavelengths outside the wavelength range of input data
  are discarded. A numerical value can be also be provided as fill. While
  \code{interpolate_spectrum} supports interpolation of a single numeric
  vector, \code{interpolate_wl} applies, one at a time, interpolation to all
  numeric columns found in \code{x}.
}
\examples{

my.w.length <- 300:700
with(sun.data, interpolate_spectrum(w.length, s.e.irrad, my.w.length))

}
\seealso{
\code{\link[stats:splinefun]{spline}()} and
  \code{\link[stats:approxfun]{approx}()}.

Other low-level functions operating on numeric vectors.: 
\code{\link{as_energy}()},
\code{\link{as_quantum_mol}()},
\code{\link{calc_multipliers}()},
\code{\link{div_spectra}()},
\code{\link{energy_irradiance}()},
\code{\link{energy_ratio}()},
\code{\link{insert_hinges}()},
\code{\link{integrate_xy}()},
\code{\link{irradiance}()},
\code{\link{l_insert_hinges}()},
\code{\link{oper_spectra}()},
\code{\link{photon_irradiance}()},
\code{\link{photon_ratio}()},
\code{\link{photons_energy_ratio}()},
\code{\link{prod_spectra}()},
\code{\link{s_e_irrad2rgb}()},
\code{\link{split_energy_irradiance}()},
\code{\link{split_photon_irradiance}()},
\code{\link{subt_spectra}()},
\code{\link{sum_spectra}()},
\code{\link{trim_tails}()},
\code{\link{v_insert_hinges}()},
\code{\link{v_replace_hinges}()}
}
\concept{low-level functions operating on numeric vectors.}
