% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.summaries.r
\name{print.metadata}
\alias{print.metadata}
\alias{print.instr_desc}
\alias{print.instr_settings}
\alias{print.filter_properties}
\alias{print.solute_properties}
\title{Print methods for metadata records}
\usage{
\method{print}{instr_desc}(x, ...)

\method{print}{instr_settings}(x, ...)

\method{print}{filter_properties}(x, ...)

\method{print}{solute_properties}(x, ...)
}
\arguments{
\item{x}{An object of one of the summary classes for spectra.}

\item{...}{not used in current version.}
}
\description{
Print methods for objects of classes used to store different meta data
properties in the classes for different types of spectra.
}
\details{
These methods print an abbreviated representaion of objects used
to store metadata in attributes. They are similar to \emph{records} and
formatted printing is useful both on its own and in the print methods for
spectra and their summaries.
}
\examples{

print(getInstrDesc(sun_evening.spct))
str(getInstrDesc(sun_evening.spct))

print(getInstrSettings(sun_evening.spct))
str(getInstrSettings(sun_evening.spct))

print(filter_properties(polyester.spct))
str(filter_properties(polyester.spct))

print(solute_properties(phenylalanine.spct))
str(solute_properties(phenylalanine.spct))

}
