% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth.r
\name{CH4}
\alias{CH4}
\title{Constructor of CH4 production from pectin weighted waveband}
\usage{
CH4(norm = 300, w.low = 275, w.high = 400)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting function
and normalization wavelength.
}
\description{
Methane production from pectin BSWF
}
\examples{
CH4()
CH4(norm = 400)

}
\references{
Bloom, A. A.; Lee-Taylor, J.; Madronich, S.; Messenger, D. J.; Palmer, P. I.;
Reay, D. S. & McLeod, A. R. (2010) Global methane emission estimates from
ultraviolet irradiation of terrestrial plant foliage. New Phytologist,
Blackwell Publishing Ltd, 187, 417--425 .
}
\seealso{
\code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: 
\code{\link{DNA_GM}()},
\code{\link{DNA_N}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_M}()},
\code{\link{GEN_T}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()},
\code{\link{erythema}()}
}
\concept{BSWF weighted wavebands}
