% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_windshear.R
\name{metar_windshear}
\alias{metar_windshear}
\title{Get wind shear information.}
\usage{
metar_windshear(x, metric = TRUE)
}
\arguments{
\item{x}{character vector; METAR weather report or reports.}

\item{metric}{For the default metric = TRUE a returned wind speed is in m/s. If it's FALSE, in knots.}
}
\value{
A character vector with information about wind shear.
}
\description{
Function extracts information about wind shear from METAR weather report.
}
\examples{
metar_windshear("METAR VHHH 180800Z 12009KT 060V150 FEW010 SCT045 22/18 Q1012 WS R07R")
metar_windshear("CYWG 172000Z 30015G25KT 3/4SM R36/4000FT/D M05/M08 A2992 WS RWY36")
metar_windshear("KPIT 091730Z 091818 22020KT 3SM -SHRA BKN020 WS015/30045KT",
 metric = FALSE)

}
