% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_modify.R
\name{pocket_modify}
\alias{pocket_modify}
\title{pocket_modify}
\usage{
pocket_modify(
  actions,
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{actions}{List. List of lists where each element is an action object. See https://getpocket.com/developer/docs/v3/modify.}

\item{consumer_key}{Character string. Your Pocket consumer key. Defaults to \code{Sys.getenv("POCKET_CONSUMER_KEY")}.}

\item{access_token}{Character string. Your Pocket request token. Defaults to \code{Sys.getenv("POCKET_ACCESS_TOKEN")}.}
}
\description{
Function that sends a request with a list of actions to the 'modify' Pocket API endpoint.
}
\details{
see https://getpocket.com/developer/docs/v3/modify. This function uses the \code{modify} endpoint of the Pocket API which exhibits some weird behaviour. 
For example, even if a `modify` action is not successful, the API will still return "success". 
See [issue [#26](https://github.com/CorrelAid/pocketapi/issues/26) for a discussion.
}
