% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_store.R
\name{tbl_get}
\alias{tbl_get}
\title{Obtain a materialized table via a table store}
\usage{
tbl_get(tbl, store = NULL)
}
\arguments{
\item{tbl}{The table to retrieve from a table \code{store}. This table could be
identified by its name (e.g., \code{tbl = "large_table"}) or by supplying a
reference using a subset (with \code{$}) of the \code{tbl_store} object (e.g., \code{tbl = store$large_table}). If using the latter method then nothing needs to be
supplied to \code{store}.}

\item{store}{Either a table store object created by the \code{\link[=tbl_store]{tbl_store()}}
function or a path to a table store YAML file created by \code{\link[=yaml_write]{yaml_write()}}.}
}
\value{
A table object.
}
\description{
The \code{tbl_get()} function gives us the means to materialize a table that has
an entry in a table store (i.e., has a table-prep formula with a unique
name). The table store that is used for this can be in the form of a
\code{tbl_store} object (created with the \code{\link[=tbl_store]{tbl_store()}} function) or an on-disk
YAML representation of a table store (created by using \code{\link[=yaml_write]{yaml_write()}} with a
\code{tbl_store} object).

Should you want a table-prep formula from a table store to use as a value for
\code{tbl} (in \code{\link[=create_agent]{create_agent()}}, \code{\link[=create_informant]{create_informant()}}, or \code{\link[=set_tbl]{set_tbl()}}), then have
a look at the \code{\link[=tbl_source]{tbl_source()}} function.
}
\section{Examples}{


Define a \code{tbl_store} object by adding several table-prep formulas in
\code{\link[=tbl_store]{tbl_store()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{store <- 
  tbl_store(
    small_table_duck ~ db_tbl(
      table = small_table,
      dbname = ":memory:",
      dbtype = "duckdb"
    ),
    ~ db_tbl(
      table = "rna",
      dbname = "pfmegrnargs",
      dbtype = "postgres",
      host = "hh-pgsql-public.ebi.ac.uk",
      port = 5432,
      user = I("reader"),
      password = I("NWDMCE5xdipIjRrp")
    ),
    sml_table ~ pointblank::small_table
  )
}\if{html}{\out{</div>}}

Once this object is available, we can access the tables named:
\code{"small_table_duck"}, \code{"rna"}, and \code{"sml_table"}. Let's check that the
\code{"rna"} table is accessible through \code{\link[=tbl_get]{tbl_get()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl_get(
  tbl = "rna",
  store = store
)
}\if{html}{\out{</div>}}

\preformatted{## # Source:   table<rna> [?? x 9]
## # Database: postgres [reader@hh-pgsql-public.ebi.ac.uk:5432/pfmegrnargs]
##          id upi        timestamp           userstamp crc64   len seq_short
##     <int64> <chr>      <dttm>              <chr>     <chr> <int> <chr>    
##  1 24583872 URS000177… 2019-12-02 13:26:08 rnacen    C380…   511 ATTGAACG…
##  2 24583873 URS000177… 2019-12-02 13:26:08 rnacen    BC42…   390 ATGGGCGA…
##  3 24583874 URS000177… 2019-12-02 13:26:08 rnacen    19A5…   422 CTACGGGA…
##  4 24583875 URS000177… 2019-12-02 13:26:08 rnacen    66E1…   534 AGGGTTCG…
##  5 24583876 URS000177… 2019-12-02 13:26:08 rnacen    CC8F…   252 TACGTAGG…
##  6 24583877 URS000177… 2019-12-02 13:26:08 rnacen    19E4…   413 ATGGGCGA…
##  7 24583878 URS000177… 2019-12-02 13:26:08 rnacen    AE91…   253 TACGAAGG…
##  8 24583879 URS000177… 2019-12-02 13:26:08 rnacen    E21A…   304 CAGCAGTA…
##  9 24583880 URS000177… 2019-12-02 13:26:08 rnacen    1AA7…   460 CCTACGGG…
## 10 24583881 URS000177… 2019-12-02 13:26:08 rnacen    2046…   440 CCTACGGG…
## # … with more rows, and 2 more variables: seq_long <chr>, md5 <chr>}


An alternative method for getting the same table materialized is by using \code{$}
to get the formula of choice from \code{tbls} and passing that to \code{tbl_get()}. The
benefit of this is that we can use autocompletion to show us what's available
in the table store (i.e., appears after typing the \code{$}).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{store$small_table_duck \%>\% tbl_get()
}\if{html}{\out{</div>}}

\preformatted{## # Source:   table<small_table> [?? x 8]
## # Database: duckdb_connection
##    date_time           date           a b             c      d e     f    
##    <dttm>              <date>     <int> <chr>     <dbl>  <dbl> <lgl> <chr>
##  1 2016-01-04 11:00:00 2016-01-04     2 1-bcd-345     3  3423. TRUE  high 
##  2 2016-01-04 00:32:00 2016-01-04     3 5-egh-163     8 10000. TRUE  low  
##  3 2016-01-05 13:32:00 2016-01-05     6 8-kdg-938     3  2343. TRUE  high 
##  4 2016-01-06 17:23:00 2016-01-06     2 5-jdo-903    NA  3892. FALSE mid  
##  5 2016-01-09 12:36:00 2016-01-09     8 3-ldm-038     7   284. TRUE  low  
##  6 2016-01-11 06:15:00 2016-01-11     4 2-dhe-923     4  3291. TRUE  mid  
##  7 2016-01-15 18:46:00 2016-01-15     7 1-knw-093     3   843. TRUE  high 
##  8 2016-01-17 11:27:00 2016-01-17     4 5-boe-639     2  1036. FALSE low  
##  9 2016-01-20 04:30:00 2016-01-20     3 5-bce-642     9   838. FALSE high 
## 10 2016-01-20 04:30:00 2016-01-20     3 5-bce-642     9   838. FALSE high 
## # … with more rows}
}

\section{Function ID}{

1-10
}

\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{draft_validation}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
