% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_agent_x_list.R
\name{get_agent_x_list}
\alias{get_agent_x_list}
\title{Get the agent's \strong{x-list}}
\usage{
get_agent_x_list(agent, i = NULL)
}
\arguments{
\item{agent}{\emph{The pointblank agent object}

\verb{obj:<ptblank_agent>} // \strong{required}

A \strong{pointblank} \emph{agent} object that is commonly created through the use of
the \code{\link[=create_agent]{create_agent()}} function.}

\item{i}{\emph{A validation step number}

\verb{scalar<integer>} // \emph{default:} \code{NULL} (\code{optional})

The validation step number, which is assigned to each validation step in
the order of invocation. If \code{NULL} (the default), the \strong{x-list} will
provide information for all validation steps. If a valid step number is
provided then \strong{x-list} will have information pertaining only to that
step.}
}
\value{
An \code{x_list} object.
}
\description{
The agent's \strong{x-list} is a record of information that the agent possesses at
any given time. The \strong{x-list} will contain the most complete information
after an interrogation has taken place (before then, the data largely
reflects the validation plan). The \strong{x-list} can be constrained to a
particular validation step (by supplying the step number to the \code{i}
argument), or, we can get the information for all validation steps by leaving
\code{i} unspecified. The \strong{x-list} is indeed an R \code{list} object that contains a
veritable cornucopia of information.

For an \strong{x-list} obtained with \code{i} specified for a validation step, the
following components are available:
\itemize{
\item \code{time_start}: the time at which the interrogation began
(\verb{POSIXct [0 or 1]})
\item \code{time_end}: the time at which the interrogation ended
(\verb{POSIXct [0 or 1]})
\item \code{label}: the optional label given to the agent (\code{chr [1]})
\item \code{tbl_name}: the name of the table object, if available (\code{chr [1]})
\item \code{tbl_src}: the type of table used in the validation (\code{chr [1]})
\item \code{tbl_src_details}: if the table is a database table, this provides
further details for the DB table (\code{chr [1]})
\item \code{tbl}: the table object itself
\item \code{col_names}: the table's column names (\code{chr [ncol(tbl)]})
\item \code{col_types}: the table's column types (\code{chr [ncol(tbl)]})
\item \code{i}: the validation step index (\code{int [1]})
\item \code{type}: the type of validation, value is validation function name
(\code{chr [1]})
\item \code{columns}: the columns specified for the validation function
(\verb{chr [variable length]})
\item \code{values}: the values specified for the validation function
(\verb{mixed types [variable length]})
\item \code{briefs}: the brief for the validation step in the specified \code{lang}
(\code{chr [1]})
\item \code{eval_error}, \code{eval_warning}: indicates whether the evaluation of the
step function, during interrogation, resulted in an error or a warning
(\code{lgl [1]})
\item \code{capture_stack}: a list of captured errors or warnings during
step-function evaluation at interrogation time (\code{list [1]})
\item \code{n}: the number of test units for the validation step (\code{num [1]})
\item \code{n_passed}, \code{n_failed}: the number of passing and failing test units
for the validation step (\code{num [1]})
\item \code{f_passed}: the fraction of passing test units for the validation step,
\code{n_passed} / \code{n} (\code{num [1]})
\item \code{f_failed}: the fraction of failing test units for the validation step,
\code{n_failed} / \code{n} (\code{num [1]})
\item \code{warn}, \code{stop}, \code{notify}: a logical value indicating whether the level
of failing test units caused the corresponding conditions to be entered
(\code{lgl [1]})
\item \code{lang}: the two-letter language code that indicates which
language should be used for all briefs, the agent report, and the reporting
generated by the \code{\link[=scan_data]{scan_data()}} function (\code{chr [1]})
}

If \code{i} is unspecified (i.e., not constrained to a specific validation step)
then certain length-one components in the \strong{x-list} will be expanded to the
total number of validation steps (these are: \code{i}, \code{type}, \code{columns},
\code{values}, \code{briefs}, \code{eval_error}, \code{eval_warning}, \code{capture_stack}, \code{n},
\code{n_passed}, \code{n_failed}, \code{f_passed}, \code{f_failed}, \code{warn}, \code{stop}, and
\code{notify}). The \strong{x-list} will also have additional components when \code{i} is
\code{NULL}, which are:
\itemize{
\item \code{report_object}: a \strong{gt} table object, which is also presented as the
default print method for a \code{ptblank_agent}
\item \code{email_object}: a \strong{blastula} \code{email_message} object with a default
set of components
\item \code{report_html}: the HTML source for the \code{report_object}, provided as
a length-one character vector
\item \code{report_html_small}: the HTML source for a narrower, more condensed
version of \code{report_object}, provided as a length-one character vector; The
HTML has inlined styles, making it more suitable for email message bodies
}
}
\section{Examples}{


Create a simple data frame with a column of numerical values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(a = c(5, 7, 8, 5))

tbl
#> # A tibble: 4 x 1
#>       a
#>   <dbl>
#> 1     5
#> 2     7
#> 3     8
#> 4     5
}\if{html}{\out{</div>}}

Create an \code{action_levels()} list with fractional values for the \code{warn},
\code{stop}, and \code{notify} states.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{al <-
  action_levels(
    warn_at = 0.2,
    stop_at = 0.8,
    notify_at = 0.345
  )
}\if{html}{\out{</div>}}

Create an agent (giving it the \code{tbl} and the \code{al} objects), supply two
validation step functions, then interrogate.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(
    tbl = tbl,
    actions = al
  ) \%>\%
  col_vals_gt(columns = a, value = 7) \%>\%
  col_is_numeric(columns = a) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Get the \code{f_passed} component of the agent x-list.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- get_agent_x_list(agent)

x$f_passed
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] 0.25 1.00
}\if{html}{\out{</div>}}
}

\section{Function ID}{

8-1
}

\seealso{
Other Post-interrogation: 
\code{\link{all_passed}()},
\code{\link{get_data_extracts}()},
\code{\link{get_sundered_data}()},
\code{\link{write_testthat_file}()}
}
\concept{Post-interrogation}
