% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_read_informant.R
\name{yaml_informant_incorporate}
\alias{yaml_informant_incorporate}
\title{Get an \emph{informant} from \strong{pointblank} YAML and \code{incorporate()}}
\usage{
yaml_informant_incorporate(filename, path = NULL)
}
\arguments{
\item{filename}{\emph{File name}

\verb{scalar<character>} // \strong{required}

The name of the YAML file that contains fields related to an \emph{informant}.}

\item{path}{\emph{File path}

\verb{scalar<character>} // \emph{default:} \code{NULL} (\code{optional})

An optional path to the YAML file (combined with \code{filename}).}
}
\value{
A \code{ptblank_informant} object.
}
\description{
The \code{yaml_informant_incorporate()} function operates much like the
\code{\link[=yaml_read_informant]{yaml_read_informant()}} function (reading a \strong{pointblank} YAML file and
generating an \emph{informant} with all information in place). The key difference
is that this function takes things a step further and incorporates aspects
from the the target table (defined by table-prep formula that is required in
the YAML file). The additional auto-invocation of \code{\link[=incorporate]{incorporate()}} uses the
default options of that function. As with \code{\link[=yaml_read_informant]{yaml_read_informant()}} the
informant is returned except, this time, it has been updated with the latest
information from the target table.
}
\section{Examples}{


There's a YAML file available in the \strong{pointblank} package that's called
\code{"informant-small_table.yml"}. The path for it can be accessed through
\code{system.file()}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{yml_file_path <- 
  system.file(
    "yaml", "informant-small_table.yml",
    package = "pointblank"
  )
}\if{html}{\out{</div>}}

The YAML file can be read as an informant by using the
\code{yaml_informant_incorporate()} function. If you expect metadata to change
with time, it's best to use \code{yaml_informant_incorporate()} instead of
\code{\link[=yaml_read_informant]{yaml_read_informant()}} since the former will go the extra mile and perform
\code{\link[=incorporate]{incorporate()}} in addition to the reading.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{informant <- yaml_informant_incorporate(filename = yml_file_path)

informant
}\if{html}{\out{</div>}}

\if{html}{
\out{
<img src="https://raw.githubusercontent.com/rstudio/pointblank/main/images/man_yaml_write_3.png" alt="This image was generated from the third code example in the `yaml_write()` help file." style="width:100\%;">
}
}

As can be seen from the information report, the available table metadata was
restored and reported. If the metadata were to change with time, that would
be updated as well.
}

\section{Function ID}{

11-7
}

\seealso{
Other pointblank YAML: 
\code{\link{yaml_agent_interrogate}()},
\code{\link{yaml_agent_show_exprs}()},
\code{\link{yaml_agent_string}()},
\code{\link{yaml_exec}()},
\code{\link{yaml_read_agent}()},
\code{\link{yaml_read_informant}()},
\code{\link{yaml_write}()}
}
\concept{pointblank YAML}
