% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{limits}
\alias{limits}
\title{Matrix of prior limits}
\format{
a matrix with 8 rows and 2 columns. Each of the rows corresponds to a
different parameter:

\describe{

\item{N1}{relative size of the first population. This population
corresponds to the C ecotype.}

\item{N2}{relative size of the second population. This population
corresponds to the W ecotype.}

\item{Split}{time, in 4Nref scale, of the split event that creates the two
populations.}

\item{PoolError}{error associated with DNA pooling.}

\item{SeqError}{error associated with DNA sequencing.}

\item{pM}{proportion of the genome with no barriers against gene flow. This
is the proportion of simulated loci where migration occurs in both
directions between the divergent ecotypes.}

\item{mig_CW}{scaled migration rate between the two divergent ecotypes This
is the migration rate from ecotype C to ecotype W.}

\item{mig_WC}{scaled migration rate between the two divergent ecotypes This
is the migration rate from ecotype W to ecotype C.} }
}
\source{
simulations performed
}
\usage{
limits
}
\description{
this imports a matrix with the limits of the prior distribution
for each parameter. Each row of the matrix is a different parameter,
indicated by the row name. The matrix contains two columns, the first being
the minimum value of the distribution and the second being the maximum
value.
}
\keyword{datasets}
