% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pre.R
\name{summary.pre}
\alias{summary.pre}
\title{Summary method for objects of class pre}
\usage{
\method{summary}{pre}(object, penalty.par.val = "lambda.1se", ...)
}
\arguments{
\item{object}{An object of class \code{\link{pre}}.}

\item{penalty.par.val}{character or numeric. Value of the penalty parameter
\eqn{\lambda} to be employed for selecting the final ensemble. The default
\code{"lambda.min"} employs the \eqn{\lambda} value within 1 standard
error of the minimum cross-validated error. Alternatively, 
\code{"lambda.min"} may be specified, to employ the \eqn{\lambda} value
with minimum cross-validated error, or a numeric value \eqn{>0} may be 
specified, with higher values yielding a sparser ensemble. To evaluate the 
trade-off between accuracy and sparsity of the final ensemble, inspect
\code{pre_object$glmnet.fit} and \code{plot(pre_object$glmnet.fit)}.}

\item{...}{Additional arguments, to be passed to \code{\link[glmnet]{coef.cv.glmnet}}.}
}
\value{
Prints information about the fitted prediction rule ensemble.
}
\description{
\code{summary.pre} prints information about the generated prediction rule 
ensemble to the command line
}
\details{
Note that the cv error is estimated with data that was also used 
for learning rules and may be too optimistic. Use \code{\link{cvpre}} to 
obtain a more realistic estimate of future prediction error.
}
\examples{
\donttest{set.seed(42)
airq.ens <- pre(Ozone ~ ., data = airquality[complete.cases(airquality),])
summary(airq.ens)}
}
\seealso{
\code{\link{pre}}, \code{\link{print.pre}}, \code{\link{plot.pre}}, 
\code{\link{coef.pre}}, \code{\link{importance.pre}}, \code{\link{predict.pre}}, 
\code{\link{interact}}, \code{\link{cvpre}}
}
