% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postSummary.R
\name{postSummary}
\alias{postSummary}
\title{Posterior Summary}
\usage{
postSummary(pscOb, thin = 2, burn = 1000, par = "beta")
}
\arguments{
\item{pscOb}{a pscOb function which has passed through pscEst()}

\item{thin}{a thin to be applied to the posterior distributions}

\item{burn}{a burnin to ba applied to the posterior distribution}

\item{par}{the parameter to be summarised - defaults to 'beta' to summarise
all 'beta' parameters in the posterior distribution}
}
\value{
Returns a summary of a 'psc' object including details on the original
Counter Factual Model, a summary of the Data Cohort, the predicted responses
from the CFM and details on the model fit.
}
\description{
A function that provides a summary of the posterior distributions obtained
from a pscEst() procedures
}
\details{
This function makes use of the 'posterior' package to pull together
each of the 'draw' matrices included in the psc object and produce posterior
summaries
}
\examples{
e4_data <- psc::e4_data
gemCFM <- psc::gemCFM
pscOb <- pscData(gemCFM,e4_data)
pscOb <- init(pscOb)
pscOb <- pscEst(pscOb)
pscOb <- postSummary(pscOb)
}
