% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/superseded-flatten.R
\name{flatten}
\alias{flatten}
\alias{flatten_lgl}
\alias{flatten_int}
\alias{flatten_dbl}
\alias{flatten_chr}
\alias{flatten_dfr}
\alias{flatten_dfc}
\alias{flatten_df}
\title{Flatten a list of lists into a simple vector}
\usage{
flatten(.x)

flatten_lgl(.x)

flatten_int(.x)

flatten_dbl(.x)

flatten_chr(.x)

flatten_dfr(.x, .id = NULL)

flatten_dfc(.x)
}
\arguments{
\item{.x}{A list to flatten. The contents of the list can be anything for
\code{flatten()} (as a list is returned), but the contents must match the
type for the other functions.}
}
\value{
\code{flatten()} returns a list, \code{flatten_lgl()} a logical
vector, \code{flatten_int()} an integer vector, \code{flatten_dbl()} a
double vector, and \code{flatten_chr()} a character vector.

\code{flatten_dfr()} and \code{flatten_dfc()} return data frames created by
row-binding and column-binding respectively. They require dplyr to
be installed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

These functions were superseded in purrr 1.0.0 because their behaviour was
inconsistent. Superseded functions will not go away, but will only receive
critical bug fixes.
\itemize{
\item \code{flatten()} has been superseded by \code{\link[=list_flatten]{list_flatten()}}.
\item \code{flatten_lgl()}, \code{flatten_int()}, \code{flatten_dbl()}, and \code{flatten_chr()}
have been superseded by \code{\link[=list_c]{list_c()}}.
\item \code{flatten_dfr()} and \code{flatten_dfc()} have been superseded by \code{\link[=list_rbind]{list_rbind()}}
and \code{\link[=list_cbind]{list_cbind()}} respectively.
}
}
\examples{
x <- map(1:3, \(i) sample(4))
x

# was
x |> flatten_int() |> str()
# now
x |> list_c() |> str()

x <- list(list(1, 2), list(3, 4))
# was
x |> flatten() |> str()
# now
x |> list_flatten() |> str()
}
\keyword{internal}
